/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.ast.IArgumentNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.types.INameNode;
import org.jrubyparser.ast.visitor.NodeVisitor;
import org.jrubyparser.lexer.yacc.ISourcePosition;

public class AttrAssignNode
extends Node
implements INameNode,
IArgumentNode {
    protected final Node receiverNode;
    private String name;
    private Node argsNode;
    private final boolean isLazy;

    public AttrAssignNode(ISourcePosition position, Node receiverNode, String name, Node argsNode, boolean isLazy) {
        super(position, receiverNode != null && receiverNode.containsVariableAssignment() || argsNode != null && argsNode.containsVariableAssignment());
        assert (receiverNode != null) : "receiverNode is not null";
        this.receiverNode = receiverNode;
        this.name = name;
        this.argsNode = argsNode;
        this.isLazy = isLazy;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ATTRASSIGNNODE;
    }

    public Object accept(NodeVisitor visitor2) {
        return visitor2.visitAttrAssignNode(this);
    }

    public String getLexicalName() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    @Override
    public Node getArgsNode() {
        return this.argsNode;
    }

    @Override
    public Node setArgsNode(Node argsNode) {
        this.argsNode = argsNode;
        return this;
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.argsNode);
    }
}

