/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.visitor.NodeVisitor;
import org.jrubyparser.lexer.yacc.ISourcePosition;

public class CaseNode
extends Node {
    private final Node caseNode;
    private final ListNode cases;
    private Node elseNode = null;

    public CaseNode(ISourcePosition position, Node caseNode, ListNode cases) {
        super(position, caseNode != null && caseNode.containsVariableAssignment() || cases.containsVariableAssignment());
        assert (cases != null) : "caseBody is not null";
        this.caseNode = caseNode;
        this.cases = cases;
    }

    public void setElseNode(Node elseNode) {
        this.elseNode = elseNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.CASENODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitCaseNode(this);
    }

    public Node getCaseNode() {
        return this.caseNode;
    }

    public ListNode getCases() {
        return this.cases;
    }

    public Node getElseNode() {
        return this.elseNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.caseNode, (Node)this.cases);
    }
}

