/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.ast.Colon3Node;
import org.jrubyparser.ast.IScopingNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.visitor.NodeVisitor;
import org.jrubyparser.lexer.yacc.ISourcePosition;
import org.jrubyparser.parser.StaticScope;

public class ClassNode
extends Node
implements IScopingNode {
    private final Colon3Node cpath;
    private final StaticScope scope;
    private final Node bodyNode;
    private final Node superNode;

    public ClassNode(ISourcePosition position, Colon3Node cpath, StaticScope scope, Node bodyNode, Node superNode) {
        super(position, cpath.containsVariableAssignment() || bodyNode.containsVariableAssignment() || superNode != null && superNode.containsVariableAssignment());
        assert (cpath != null) : "cpath is not null";
        assert (scope != null) : "scope is not null";
        assert (bodyNode != null) : "bodyNode is not null";
        this.cpath = cpath;
        this.scope = scope;
        this.bodyNode = bodyNode;
        this.superNode = superNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.CLASSNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitClassNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public StaticScope getScope() {
        return this.scope;
    }

    @Override
    public Colon3Node getCPath() {
        return this.cpath;
    }

    public Node getSuperNode() {
        return this.superNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList((Node)this.cpath, this.bodyNode, this.superNode);
    }
}

