/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.ast.BlockAcceptingNode;
import org.jrubyparser.ast.EmptyArgsNode;
import org.jrubyparser.ast.IArgumentNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.types.INameNode;
import org.jrubyparser.ast.visitor.NodeVisitor;
import org.jrubyparser.lexer.yacc.ISourcePosition;

public class FCallNode
extends Node
implements INameNode,
IArgumentNode,
BlockAcceptingNode {
    private String name;
    protected Node argsNode;
    protected Node iterNode;

    public FCallNode(ISourcePosition position, String name) {
        this(position, name, null, null);
    }

    public FCallNode(ISourcePosition position, String name, Node argsNode, Node iterNode) {
        super(position, argsNode != null && argsNode.containsVariableAssignment() || iterNode != null && iterNode.containsVariableAssignment());
        this.name = name;
        this.argsNode = argsNode != null ? argsNode : new EmptyArgsNode();
        this.iterNode = iterNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.FCALLNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitFCallNode(this);
    }

    @Override
    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public Node setIterNode(Node iterNode) {
        this.iterNode = iterNode;
        return this;
    }

    @Override
    public Node getArgsNode() {
        return this.argsNode;
    }

    @Override
    public Node setArgsNode(Node argsNode) {
        if (argsNode != null) {
            this.argsNode = argsNode;
        }
        return argsNode;
    }

    public String getLexicalName() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return FCallNode.createList(this.argsNode, this.iterNode);
    }
}

