/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.ArrayList;
import java.util.List;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.types.ILiteralNode;
import org.jrubyparser.ast.visitor.NodeVisitor;
import org.jrubyparser.lexer.yacc.ISourcePosition;
import org.jrubyparser.util.KeyValuePair;

public class HashNode
extends Node
implements ILiteralNode {
    private final List<KeyValuePair<Node, Node>> pairs = new ArrayList<KeyValuePair<Node, Node>>();

    public HashNode(ISourcePosition position) {
        super(position, false);
    }

    public HashNode(ISourcePosition position, KeyValuePair<Node, Node> pair) {
        this(position);
        this.pairs.add(pair);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.HASHNODE;
    }

    public HashNode add(KeyValuePair<Node, Node> pair) {
        if (pair.getKey() != null && pair.getKey().containsVariableAssignment() || pair.getValue() != null && pair.getValue().containsVariableAssignment()) {
            this.containsVariableAssignment = true;
        }
        this.pairs.add(pair);
        return this;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitHashNode(this);
    }

    public boolean isEmpty() {
        return this.pairs.isEmpty();
    }

    public List<KeyValuePair<Node, Node>> getPairs() {
        return this.pairs;
    }

    @Override
    public List<Node> childNodes() {
        ArrayList<Node> children = new ArrayList<Node>();
        for (KeyValuePair<Node, Node> pair : this.pairs) {
            children.add(pair.getKey());
            children.add(pair.getValue());
        }
        return children;
    }
}

