/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.RescueBodyNode;
import org.jrubyparser.ast.visitor.NodeVisitor;
import org.jrubyparser.lexer.yacc.ISourcePosition;

public class RescueNode
extends Node {
    private final Node bodyNode;
    private final RescueBodyNode rescueNode;
    private final Node elseNode;

    public RescueNode(ISourcePosition position, Node bodyNode, RescueBodyNode rescueNode, Node elseNode) {
        super(position, bodyNode != null && bodyNode.containsVariableAssignment() || rescueNode != null && rescueNode.containsVariableAssignment() || elseNode != null && elseNode.containsVariableAssignment());
        this.bodyNode = bodyNode;
        this.rescueNode = rescueNode;
        this.elseNode = elseNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.RESCUENODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitRescueNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getElseNode() {
        return this.elseNode;
    }

    public RescueBodyNode getRescueNode() {
        return this.rescueNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList((Node)this.rescueNode, this.bodyNode, this.elseNode);
    }
}

