/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.parser;

import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jrubyparser.parser.StaticScope;

public class ParserConfiguration {
    private int lineNumber = 0;
    private boolean inlineSource = false;
    private boolean isEvalParse = true;
    private boolean isDebug = false;
    private boolean saveData = false;
    private StaticScope scope = null;
    private boolean frozenStringLiteral = false;
    private Encoding defaultEncoding;

    public ParserConfiguration(int lineNumber) {
        this(lineNumber, null, false, false, false);
    }

    public ParserConfiguration(int lineNumber, StaticScope scope, boolean inlineSource, boolean isFileParse, boolean saveData) {
        this.scope = scope;
        this.inlineSource = inlineSource;
        this.lineNumber = lineNumber;
        this.isEvalParse = !isFileParse;
        this.saveData = saveData;
    }

    public void setFrozenStringLiteral(boolean frozenStringLiteral) {
        this.frozenStringLiteral = frozenStringLiteral;
    }

    public boolean isFrozenStringLiteral() {
        return this.frozenStringLiteral;
    }

    public void setDefaultEncoding(Encoding encoding) {
        this.defaultEncoding = encoding;
    }

    public Encoding getDefaultEncoding() {
        if (this.defaultEncoding == null) {
            this.defaultEncoding = UTF8Encoding.INSTANCE;
        }
        return this.defaultEncoding;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public boolean isEvalParse() {
        return this.isEvalParse;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean isSaveData() {
        return this.saveData;
    }

    public StaticScope getScope() {
        return this.scope;
    }

    public boolean isInlineSource() {
        return this.inlineSource;
    }
}

