/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.util;

import java.math.BigDecimal;

class SafeDecimalParser {
    protected static final BigDecimal TWO = new BigDecimal(2);
    protected static final BigDecimal LOWER = new BigDecimal("2.22507385850720113605e-308");
    protected static final BigDecimal UPPER = new BigDecimal("2.22507385850720125958e-308");
    protected static final BigDecimal MIDDLE = LOWER.add(UPPER).divide(TWO);
    private static final Double UPPER_DOUBLE = UPPER.doubleValue();
    private static final Double LOWER_DOUBLE = LOWER.doubleValue();
    private static final String SUSPICIOUS_DIGITS = "22250738585072";

    SafeDecimalParser() {
    }

    protected static final boolean isSuspicious(String s) {
        return SafeDecimalParser.digits(s).indexOf(SUSPICIOUS_DIGITS) >= 0;
    }

    protected static final Double decimalValueOf(String s) {
        Double result = null;
        if (s != null) {
            result = SafeDecimalParser.isSuspicious(s) ? SafeDecimalParser.parseSafely(s) : Double.valueOf(s);
        }
        return result;
    }

    protected static final double decimalValue(Number number) {
        double result = 0.0;
        if (number != null) {
            result = number instanceof BigDecimal ? SafeDecimalParser.decimalValue((BigDecimal)number) : number.doubleValue();
        }
        return result;
    }

    protected static final double decimalValue(BigDecimal bigDecimal) {
        double result = 0.0;
        if (bigDecimal != null) {
            result = SafeDecimalParser.isDangerous(bigDecimal) ? SafeDecimalParser.decimalValueOf(bigDecimal.toString()).doubleValue() : bigDecimal.doubleValue();
        }
        return result;
    }

    private static final Double parseSafely(String s) {
        BigDecimal bd = new BigDecimal(s);
        Double result = SafeDecimalParser.isDangerous(bd) ? (bd.compareTo(MIDDLE) >= 0 ? UPPER_DOUBLE : LOWER_DOUBLE) : Double.valueOf(s);
        return result;
    }

    private static final String digits(String s) {
        char[] ca = s.toCharArray();
        int len = ca.length;
        StringBuilder b = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = ca[i];
            if (c < '0' || c > '9') continue;
            b.append(c);
        }
        return b.toString();
    }

    private static final boolean isDangerous(BigDecimal bd) {
        return bd.compareTo(UPPER) < 0 && bd.compareTo(LOWER) > 0;
    }
}

