/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.analysis.utils;

import com.google.common.io.LittleEndianDataInputStream;
import com.sourceclear.analysis.utils.PeFileType;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.commons.io.IOUtils;

public final class PeFileTypeDetector {
    public static Optional<PeFileType> detectFileType(Path dll) throws IOException {
        try (LittleEndianDataInputStream stream = new LittleEndianDataInputStream(Files.newInputStream(dll, new OpenOption[0]));){
            byte[] magicBytes = new byte[2];
            IOUtils.readFully((InputStream)stream, (byte[])magicBytes);
            if (magicBytes[0] != 77 || magicBytes[1] != 90) {
                Optional<PeFileType> optional = Optional.empty();
                return optional;
            }
            IOUtils.skip((InputStream)stream, (long)58L);
            int peOffset = stream.readInt();
            if (peOffset > 4096 || peOffset < 63) {
                Optional<PeFileType> optional = Optional.empty();
                return optional;
            }
            IOUtils.skip((InputStream)stream, (long)(peOffset - 64));
            byte[] peHeader = new byte[24];
            IOUtils.readFully((InputStream)stream, (byte[])peHeader);
            if (peHeader[0] != 80 || peHeader[1] != 69 || peHeader[2] != 0 || peHeader[3] != 0) {
                Optional<PeFileType> optional = Optional.empty();
                return optional;
            }
            int peFormatMagic = stream.readUnsignedShort();
            if (peFormatMagic == 267) {
                IOUtils.skip((InputStream)stream, (long)208L);
            } else if (peFormatMagic == 523) {
                IOUtils.skip((InputStream)stream, (long)224L);
            }
            if (stream.readLong() == 0L) {
                Optional<PeFileType> optional = Optional.of(PeFileType.NativePe);
                return optional;
            }
            Optional<PeFileType> optional = Optional.of(PeFileType.ManagedPe);
            return optional;
        }
    }
}

