/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sourceclear.api.data.events.RepoModel;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.LongUnaryOperator;
import java.util.function.UnaryOperator;

abstract class RepoModel_Builder {
    private long id;
    private String name;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    RepoModel_Builder() {
    }

    public static RepoModel.Builder from(RepoModel value) {
        if (value instanceof Rebuildable) {
            return ((Rebuildable)value).toBuilder();
        }
        return new RepoModel.Builder().mergeFrom(value);
    }

    @JsonProperty(value="id")
    public RepoModel.Builder setId(long id) {
        this.id = id;
        this._unsetProperties.remove((Object)Property.ID);
        return (RepoModel.Builder)this;
    }

    public RepoModel.Builder mapId(LongUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return this.setId(mapper.applyAsLong(this.getId()));
    }

    public long getId() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.ID) ? 1 : 0) != 0, (Object)"id not set");
        return this.id;
    }

    @JsonProperty(value="name")
    public RepoModel.Builder setName(String name) {
        this.name = Objects.requireNonNull(name);
        this._unsetProperties.remove((Object)Property.NAME);
        return (RepoModel.Builder)this;
    }

    public RepoModel.Builder mapName(UnaryOperator<String> mapper) {
        Objects.requireNonNull(mapper);
        return this.setName((String)mapper.apply(this.getName()));
    }

    public String getName() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.NAME) ? 1 : 0) != 0, (Object)"name not set");
        return this.name;
    }

    public RepoModel.Builder mergeFrom(RepoModel value) {
        RepoModel.Builder defaults = new RepoModel.Builder();
        if (defaults._unsetProperties.contains((Object)Property.ID) || value.getId() != ((RepoModel_Builder)defaults).getId()) {
            this.setId(value.getId());
        }
        if (defaults._unsetProperties.contains((Object)Property.NAME) || !Objects.equals(value.getName(), ((RepoModel_Builder)defaults).getName())) {
            this.setName(value.getName());
        }
        return (RepoModel.Builder)this;
    }

    public RepoModel.Builder mergeFrom(RepoModel.Builder template) {
        RepoModel.Builder base = template;
        RepoModel.Builder defaults = new RepoModel.Builder();
        if (!base._unsetProperties.contains((Object)Property.ID) && (defaults._unsetProperties.contains((Object)Property.ID) || template.getId() != ((RepoModel_Builder)defaults).getId())) {
            this.setId(template.getId());
        }
        if (!(base._unsetProperties.contains((Object)Property.NAME) || !defaults._unsetProperties.contains((Object)Property.NAME) && Objects.equals(template.getName(), ((RepoModel_Builder)defaults).getName()))) {
            this.setName(template.getName());
        }
        return (RepoModel.Builder)this;
    }

    public RepoModel.Builder clear() {
        RepoModel.Builder defaults = new RepoModel.Builder();
        this.id = defaults.id;
        this.name = defaults.name;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(defaults._unsetProperties);
        return (RepoModel.Builder)this;
    }

    public RepoModel build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    @VisibleForTesting
    public RepoModel buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    extends Rebuildable {
        private final long id;
        private final String name;
        private final EnumSet<Property> _unsetProperties;

        Partial(RepoModel_Builder builder) {
            this.id = builder.id;
            this.name = builder.name;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="id")
        public long getId() {
            if (this._unsetProperties.contains((Object)Property.ID)) {
                throw new UnsupportedOperationException("id not set");
            }
            return this.id;
        }

        @Override
        @JsonProperty(value="name")
        public String getName() {
            if (this._unsetProperties.contains((Object)Property.NAME)) {
                throw new UnsupportedOperationException("name not set");
            }
            return this.name;
        }

        @Override
        public RepoModel.Builder toBuilder() {
            PartialBuilder builder = new PartialBuilder();
            ((RepoModel_Builder)builder).id = this.id;
            ((RepoModel_Builder)builder).name = this.name;
            ((RepoModel_Builder)builder)._unsetProperties.clear();
            ((RepoModel_Builder)builder)._unsetProperties.addAll(this._unsetProperties);
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return this.id == other.id && Objects.equals(this.name, other.name) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this._unsetProperties);
        }

        public String toString() {
            StringBuilder result = new StringBuilder("partial RepoModel{");
            String separator = "";
            if (!this._unsetProperties.contains((Object)Property.ID)) {
                result.append("id=").append(this.id);
                separator = ", ";
            }
            if (!this._unsetProperties.contains((Object)Property.NAME)) {
                result.append(separator).append("name=").append(this.name);
            }
            return result.append("}").toString();
        }

        private static class PartialBuilder
        extends RepoModel.Builder {
            private PartialBuilder() {
            }

            @Override
            public RepoModel build() {
                return this.buildPartial();
            }
        }
    }

    private static final class Value
    extends Rebuildable {
        private final long id;
        private final String name;

        private Value(RepoModel_Builder builder) {
            this.id = builder.id;
            this.name = builder.name;
        }

        @Override
        @JsonProperty(value="id")
        public long getId() {
            return this.id;
        }

        @Override
        @JsonProperty(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        public RepoModel.Builder toBuilder() {
            RepoModel.Builder builder = new RepoModel.Builder();
            ((RepoModel_Builder)builder).id = this.id;
            ((RepoModel_Builder)builder).name = this.name;
            ((RepoModel_Builder)builder)._unsetProperties.clear();
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return this.id == other.id && Objects.equals(this.name, other.name);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name);
        }

        public String toString() {
            return "RepoModel{id=" + this.id + ", name=" + this.name + "}";
        }
    }

    private static abstract class Rebuildable
    implements RepoModel {
        private Rebuildable() {
        }

        public abstract RepoModel.Builder toBuilder();
    }

    private static enum Property {
        ID("id"),
        NAME("name");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

