/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.exceptions;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ServiceException
extends RuntimeException {
    static final int SC_BAD_REQUEST = 400;
    static final int SC_NOT_FOUND = 404;
    static final int SC_INTERNAL_SERVER_ERROR = 500;
    static final int SC_SERVICE_UNAVAILABLE = 503;
    private final HttpMethod method;
    private final URI url;
    private final int httpStatusCode;

    public static ServiceException create(@Nonnull HttpMethod method, @Nonnull URI url, int statusCode, @Nullable String message, @Nullable Throwable cause) {
        return new ServiceException(Objects.requireNonNull(method, "HTTP method is required"), Objects.requireNonNull(url, "request URL is required"), message, statusCode, cause);
    }

    ServiceException(@Nullable HttpMethod method, @Nullable URI url, @Nullable String message, int httpStatusCode, @Nullable Throwable cause) {
        super(message, cause);
        this.method = method;
        this.url = url;
        this.httpStatusCode = httpStatusCode;
    }

    @Nullable
    public HttpMethod getMethod() {
        return this.method;
    }

    @Nullable
    public URI getUrl() {
        return this.url;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public static enum HttpMethod {
        GET,
        HEAD,
        POST,
        PUT,
        PATCH,
        DELETE,
        OPTIONS,
        TRACE;

        private static final Map<String, HttpMethod> mappings;

        @Nullable
        public static HttpMethod resolve(String method) {
            return method != null ? mappings.get(method) : null;
        }

        static {
            mappings = new HashMap<String, HttpMethod>(8);
            for (HttpMethod httpMethod : HttpMethod.values()) {
                mappings.put(httpMethod.name(), httpMethod);
            }
        }
    }
}

