/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.methods;

import com.sourceclear.analysis.latte.frameworks.Frameworks;
import com.sourceclear.api.data.methods.CallChainModel;
import com.sourceclear.api.data.methods.MethodCallData;
import com.sourceclear.api.data.methods.MethodModel;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.methods.InstanceFrameworkMethod;
import com.sourceclear.methods.CallGraph;
import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.VulnMethodsConfig;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public interface MethodsEngine {
    public Result scanMethods(Path var1, Collection<MethodCallData> var2, LogStream var3);

    public MethodsEngine withPublicMethodStubs(Collection<MethodInfo> var1);

    public MethodsEngine withDynamicEdges(Set<CallSite> var1);

    public MethodsEngine withFrameworkMethodStubs(Collection<InstanceFrameworkMethod> var1);

    public MethodsEngine withVulnMethodsConfig(VulnMethodsConfig var1);

    public Collection<MethodInfo> getPublicMethodStubs();

    public MethodInfo toMethodInfo(MethodModel var1, boolean var2);

    public Set<CallSite> getDynamicEdges();

    public Collection<Frameworks.Module> getFrameworkMethodStubs();

    public VulnMethodsConfig.Builder defaultConfig();

    public static class Result {
        public final Collection<MethodCallData> methodCallData;
        public final Set<CallGraph> callGraph;
        public final Map<CallChainModel, CallSite> spanningEdges;

        public Result(Collection<MethodCallData> methodCallData, Set<CallGraph> callGraph, Map<CallChainModel, CallSite> spanningEdges) {
            this.methodCallData = methodCallData;
            this.callGraph = callGraph;
            this.spanningEdges = spanningEdges;
        }

        public static Result empty() {
            return new Result(new HashSet<MethodCallData>(), new HashSet<CallGraph>(), new HashMap<CallChainModel, CallSite>());
        }
    }
}

