/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods;

import com.google.common.collect.Sets;
import com.sourceclear.methods.CallChain;
import com.sourceclear.methods.CallGraphTraversal;
import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.JGCallGraph;
import com.sourceclear.methods.MethodInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class JavaCallGraphTraversal
implements CallGraphTraversal {
    private final JGCallGraph callGraph;

    JavaCallGraphTraversal(JGCallGraph callGraph) {
        this.callGraph = callGraph;
    }

    @Override
    public Map<MethodInfo, Collection<CallChain>> callChainsFrom(Collection<MethodInfo> targetMethods) {
        HashMap<MethodInfo, Collection<CallChain>> result = new HashMap<MethodInfo, Collection<CallChain>>();
        for (MethodInfo method : targetMethods) {
            HashMap<MethodInfo, Collection<CallChain>> callChains = new HashMap<MethodInfo, Collection<CallChain>>();
            HashSet<CallSite> discoveredCallSites = new HashSet<CallSite>();
            callChains.put(method, new HashSet());
            Set<CallSite> sites = this.callGraph.callersFor(method);
            if (sites.isEmpty()) {
                JavaCallGraphTraversal.merge(result, callChains);
                continue;
            }
            LinkedList<CallSite> queue = new LinkedList<CallSite>(sites);
            while (!queue.isEmpty()) {
                CallSite callSite = queue.pop();
                if (discoveredCallSites.contains(callSite)) continue;
                discoveredCallSites.add(callSite);
                MethodInfo caller = callSite.getCaller();
                JavaCallGraphTraversal.addCallSiteToCallChains(callChains, callSite);
                Set<CallSite> callers = this.callGraph.callersFor(caller);
                queue.addAll(callers);
            }
            JavaCallGraphTraversal.merge(result, callChains);
        }
        return result;
    }

    private static void merge(HashMap<MethodInfo, Collection<CallChain>> a, HashMap<MethodInfo, Collection<CallChain>> b) {
        for (Map.Entry<MethodInfo, Collection<CallChain>> entry : b.entrySet()) {
            MethodInfo key = entry.getKey();
            Collection<CallChain> value = entry.getValue();
            if (a.containsKey(key)) {
                a.get(key).addAll(value);
                continue;
            }
            a.put(key, value);
        }
    }

    private static void addCallSiteToCallChains(Map<MethodInfo, Collection<CallChain>> callChains, CallSite site) {
        Collection<CallChain> calleeCallChains = callChains.get(site.getCallee());
        assert (calleeCallChains != null);
        HashSet<Object> callerCallChains = new HashSet<Object>();
        if (calleeCallChains.isEmpty()) {
            CallChain callerCallChain = new CallChain();
            callerCallChain.add(site);
            callerCallChains.add(callerCallChain);
        } else {
            for (CallChain calleeCallChain : calleeCallChains) {
                CallChain callerCallChain = new CallChain();
                callerCallChain.add(site);
                callerCallChain.append(calleeCallChain);
                callerCallChains.add(callerCallChain);
            }
        }
        MethodInfo caller = site.getCaller();
        if (callChains.get(caller) == null) {
            callChains.put(caller, callerCallChains);
        } else {
            Collection<CallChain> chains = callChains.get(caller);
            chains.addAll(callerCallChains);
            CallChain min = chains.iterator().next();
            for (CallChain chain : chains) {
                if (chain.size() >= min.size()) continue;
                min = chain;
            }
            callChains.put(caller, Sets.newHashSet((Object[])new CallChain[]{min}));
        }
    }
}

