/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.publicmethods.python;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.publicmethods.PublicMethods;
import com.sourceclear.pysonar.ast.Alias;
import com.sourceclear.pysonar.ast.Assert;
import com.sourceclear.pysonar.ast.Assign;
import com.sourceclear.pysonar.ast.Attribute;
import com.sourceclear.pysonar.ast.Await;
import com.sourceclear.pysonar.ast.BinOp;
import com.sourceclear.pysonar.ast.Block;
import com.sourceclear.pysonar.ast.Break;
import com.sourceclear.pysonar.ast.Bytes;
import com.sourceclear.pysonar.ast.Call;
import com.sourceclear.pysonar.ast.ClassDef;
import com.sourceclear.pysonar.ast.Comprehension;
import com.sourceclear.pysonar.ast.Continue;
import com.sourceclear.pysonar.ast.Delete;
import com.sourceclear.pysonar.ast.Dict;
import com.sourceclear.pysonar.ast.DictComp;
import com.sourceclear.pysonar.ast.Dummy;
import com.sourceclear.pysonar.ast.Ellipsis;
import com.sourceclear.pysonar.ast.Exec;
import com.sourceclear.pysonar.ast.Expr;
import com.sourceclear.pysonar.ast.ExtSlice;
import com.sourceclear.pysonar.ast.For;
import com.sourceclear.pysonar.ast.FunctionDef;
import com.sourceclear.pysonar.ast.GeneratorExp;
import com.sourceclear.pysonar.ast.Global;
import com.sourceclear.pysonar.ast.Handler;
import com.sourceclear.pysonar.ast.If;
import com.sourceclear.pysonar.ast.IfExp;
import com.sourceclear.pysonar.ast.Import;
import com.sourceclear.pysonar.ast.ImportFrom;
import com.sourceclear.pysonar.ast.Index;
import com.sourceclear.pysonar.ast.Keyword;
import com.sourceclear.pysonar.ast.ListComp;
import com.sourceclear.pysonar.ast.Module;
import com.sourceclear.pysonar.ast.Name;
import com.sourceclear.pysonar.ast.Node;
import com.sourceclear.pysonar.ast.Pass;
import com.sourceclear.pysonar.ast.Print;
import com.sourceclear.pysonar.ast.PyComplex;
import com.sourceclear.pysonar.ast.PyFloat;
import com.sourceclear.pysonar.ast.PyInt;
import com.sourceclear.pysonar.ast.PyList;
import com.sourceclear.pysonar.ast.PySet;
import com.sourceclear.pysonar.ast.Raise;
import com.sourceclear.pysonar.ast.Repr;
import com.sourceclear.pysonar.ast.Return;
import com.sourceclear.pysonar.ast.SetComp;
import com.sourceclear.pysonar.ast.Slice;
import com.sourceclear.pysonar.ast.Starred;
import com.sourceclear.pysonar.ast.Str;
import com.sourceclear.pysonar.ast.Subscript;
import com.sourceclear.pysonar.ast.Try;
import com.sourceclear.pysonar.ast.Tuple;
import com.sourceclear.pysonar.ast.UnaryOp;
import com.sourceclear.pysonar.ast.Unsupported;
import com.sourceclear.pysonar.ast.Url;
import com.sourceclear.pysonar.ast.While;
import com.sourceclear.pysonar.ast.With;
import com.sourceclear.pysonar.ast.Withitem;
import com.sourceclear.pysonar.ast.Yield;
import com.sourceclear.pysonar.ast.YieldFrom;
import com.sourceclear.pysonar.visitor.Visitor1;
import java.util.Stack;

public abstract class PythonMethodVisitor
extends Visitor1 {
    private final Stack<String> classes = new Stack();
    private final String moduleName;

    public PythonMethodVisitor(String moduleName) {
        this.moduleName = moduleName;
    }

    public void visit(ClassDef node) {
        this.classes.push(node.name.id);
        this.visit(node.body);
        this.classes.pop();
        super.visit(node);
    }

    public void visit(FunctionDef node) {
        this.visit(node.defaults);
        this.visit(node.body);
        String className = Strings.emptyToNull((String)Joiner.on((String)".").join(this.classes));
        String methodName = node.name.id;
        this.visitMethod(PublicMethods.pythonMethod(this.moduleName, className, methodName), node.body);
    }

    public void visit(Module node) {
        if (node.body != null) {
            this.visit(node.body);
        }
    }

    public void visit(Alias node) {
    }

    public void visit(Assert node) {
        this.visit(node.msg);
        this.visit(node.test);
    }

    public void visit(Assign node) {
        this.visit(node.value);
    }

    public void visit(Attribute node) {
        this.visit(node.target);
    }

    public void visit(Await node) {
        this.visit(node.value);
    }

    public void visit(BinOp node) {
        this.visit(node.left);
        this.visit(node.right);
    }

    public void visit(Block node) {
        this.visit(node.seq);
    }

    public void visit(Break node) {
    }

    public void visit(Bytes node) {
    }

    public void visit(Call node) {
        this.visit(node.func);
    }

    public void visit(Comprehension node) {
        this.visit(node.target);
        this.visit(node.iter);
        if (node.ifs != null) {
            this.visit(node.ifs);
        }
    }

    public void visit(Continue node) {
    }

    public void visit(Delete node) {
        this.visit(node.targets);
    }

    public void visit(Dict node) {
        this.visit(node.keys);
        this.visit(node.values);
    }

    public void visit(DictComp node) {
        this.visit(node.key);
        this.visit(node.value);
        this.visit(node.generators);
    }

    public void visit(Dummy node) {
    }

    public void visit(Ellipsis node) {
    }

    public void visit(Exec node) {
    }

    public void visit(Expr node) {
        this.visit(node.value);
    }

    public void visit(ExtSlice node) {
        this.visit(node.dims);
    }

    public void visit(For node) {
        this.visit(node.iter);
        this.visit(node.target);
        this.visit(node.body);
        if (node.orelse != null) {
            this.visit(node.orelse);
        }
    }

    public void visit(GeneratorExp node) {
        this.visit(node.generators);
        this.visit(node.elt);
    }

    public void visit(Global node) {
    }

    public void visit(Handler node) {
        this.visit(node.exceptions);
        this.visit(node.binder);
        this.visit(node.body);
    }

    public void visit(If node) {
        this.visit(node.test);
        this.visit(node.body);
        if (node.orelse != null) {
            this.visit(node.orelse);
        }
    }

    public void visit(IfExp node) {
        this.visit(node.test);
        this.visit(node.body);
        if (node.orelse != null) {
            this.visit(node.orelse);
        }
    }

    public void visit(Import node) {
    }

    public void visit(ImportFrom node) {
    }

    public void visit(Index node) {
        this.visit(node.value);
    }

    public void visit(Keyword node) {
        this.visit(node.value);
    }

    public void visit(ListComp node) {
        this.visit(node.elt);
        this.visit(node.generators);
    }

    public void visit(Name node) {
    }

    public void visit(Pass node) {
    }

    public void visit(Print node) {
        this.visit(node.dest);
        this.visit(node.values);
    }

    public void visit(PyComplex node) {
    }

    public void visit(PyFloat node) {
    }

    public void visit(PyInt node) {
    }

    public void visit(PyList node) {
        this.visit(node.elts);
    }

    public void visit(PySet node) {
        this.visit(node.elts);
    }

    public void visit(Raise node) {
        this.visit(node.exceptionType);
        this.visit(node.inst);
        this.visit(node.traceback);
    }

    public void visit(Repr node) {
        this.visit(node.value);
    }

    public void visit(Return node) {
        this.visit(node.value);
    }

    public void visit(SetComp node) {
        this.visit(node.elt);
        this.visit(node.generators);
    }

    public void visit(Slice node) {
        this.visit(node.lower);
        this.visit(node.step);
        this.visit(node.upper);
    }

    public void visit(Starred node) {
        this.visit(node.value);
    }

    public void visit(Str node) {
    }

    public void visit(Subscript node) {
        this.visit(node.value);
        this.visit(node.slice);
    }

    public void visit(Try node) {
        this.visit(node.handlers);
        if (node.body != null) {
            this.visit(node.body);
        }
        if (node.orelse != null) {
            this.visit(node.orelse);
        }
        if (node.finalbody != null) {
            this.visit(node.finalbody);
        }
    }

    public void visit(Tuple node) {
        this.visit(node.elts);
    }

    public void visit(UnaryOp node) {
        this.visit(node.operand);
    }

    public void visit(Unsupported node) {
    }

    public void visit(Url node) {
    }

    public void visit(While node) {
        this.visit(node.test);
        this.visit(node.body);
        if (node.orelse != null) {
            this.visit(node.orelse);
        }
    }

    public void visit(With node) {
        for (Withitem item : node.items) {
            this.visit(item.context_expr);
        }
        this.visit(node.body);
    }

    public void visit(Withitem node) {
    }

    public void visit(Yield node) {
        this.visit(node.value);
    }

    public void visit(YieldFrom node) {
        this.visit(node.value);
    }

    public abstract void visitMethod(MethodInfo var1, Node var2);
}

