/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl.lang;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sourceclear.sgl.lang.CompileConfig;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableCompileConfig
extends CompileConfig {
    private final boolean hasPath;
    private final boolean pathWithEdges;
    private final boolean startingVertices;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCompileConfig(Builder builder) {
        if (builder.hasPathIsSet()) {
            this.initShim.hasPath(builder.hasPath);
        }
        if (builder.pathWithEdgesIsSet()) {
            this.initShim.pathWithEdges(builder.pathWithEdges);
        }
        if (builder.startingVerticesIsSet()) {
            this.initShim.startingVertices(builder.startingVertices);
        }
        this.hasPath = this.initShim.hasPath();
        this.pathWithEdges = this.initShim.pathWithEdges();
        this.startingVertices = this.initShim.startingVertices();
        this.initShim = null;
    }

    private ImmutableCompileConfig(boolean hasPath, boolean pathWithEdges, boolean startingVertices) {
        this.hasPath = hasPath;
        this.pathWithEdges = pathWithEdges;
        this.startingVertices = startingVertices;
        this.initShim = null;
    }

    @Override
    boolean hasPath() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasPath() : this.hasPath;
    }

    @Override
    boolean pathWithEdges() {
        InitShim shim = this.initShim;
        return shim != null ? shim.pathWithEdges() : this.pathWithEdges;
    }

    @Override
    boolean startingVertices() {
        InitShim shim = this.initShim;
        return shim != null ? shim.startingVertices() : this.startingVertices;
    }

    public final ImmutableCompileConfig withHasPath(boolean value) {
        if (this.hasPath == value) {
            return this;
        }
        return new ImmutableCompileConfig(value, this.pathWithEdges, this.startingVertices);
    }

    public final ImmutableCompileConfig withPathWithEdges(boolean value) {
        if (this.pathWithEdges == value) {
            return this;
        }
        return new ImmutableCompileConfig(this.hasPath, value, this.startingVertices);
    }

    public final ImmutableCompileConfig withStartingVertices(boolean value) {
        if (this.startingVertices == value) {
            return this;
        }
        return new ImmutableCompileConfig(this.hasPath, this.pathWithEdges, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCompileConfig && this.equalTo((ImmutableCompileConfig)another);
    }

    private boolean equalTo(ImmutableCompileConfig another) {
        return this.hasPath == another.hasPath && this.pathWithEdges == another.pathWithEdges && this.startingVertices == another.startingVertices;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.hasPath);
        h += (h << 5) + Booleans.hashCode((boolean)this.pathWithEdges);
        h += (h << 5) + Booleans.hashCode((boolean)this.startingVertices);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CompileConfig").omitNullValues().add("hasPath", this.hasPath).add("pathWithEdges", this.pathWithEdges).add("startingVertices", this.startingVertices).toString();
    }

    public static ImmutableCompileConfig copyOf(CompileConfig instance) {
        if (instance instanceof ImmutableCompileConfig) {
            return (ImmutableCompileConfig)instance;
        }
        return ImmutableCompileConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_HAS_PATH = 1L;
        private static final long OPT_BIT_PATH_WITH_EDGES = 2L;
        private static final long OPT_BIT_STARTING_VERTICES = 4L;
        private long optBits;
        private boolean hasPath;
        private boolean pathWithEdges;
        private boolean startingVertices;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CompileConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.hasPath(instance.hasPath());
            this.pathWithEdges(instance.pathWithEdges());
            this.startingVertices(instance.startingVertices());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hasPath(boolean hasPath) {
            this.hasPath = hasPath;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pathWithEdges(boolean pathWithEdges) {
            this.pathWithEdges = pathWithEdges;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder startingVertices(boolean startingVertices) {
            this.startingVertices = startingVertices;
            this.optBits |= 4L;
            return this;
        }

        public ImmutableCompileConfig build() {
            return new ImmutableCompileConfig(this);
        }

        private boolean hasPathIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean pathWithEdgesIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean startingVerticesIsSet() {
            return (this.optBits & 4L) != 0L;
        }
    }

    private final class InitShim {
        private boolean hasPath;
        private int hasPathBuildStage;
        private boolean pathWithEdges;
        private int pathWithEdgesBuildStage;
        private boolean startingVertices;
        private int startingVerticesBuildStage;

        private InitShim() {
        }

        boolean hasPath() {
            if (this.hasPathBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasPathBuildStage == 0) {
                this.hasPathBuildStage = -1;
                this.hasPath = ImmutableCompileConfig.super.hasPath();
                this.hasPathBuildStage = 1;
            }
            return this.hasPath;
        }

        void hasPath(boolean hasPath) {
            this.hasPath = hasPath;
            this.hasPathBuildStage = 1;
        }

        boolean pathWithEdges() {
            if (this.pathWithEdgesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pathWithEdgesBuildStage == 0) {
                this.pathWithEdgesBuildStage = -1;
                this.pathWithEdges = ImmutableCompileConfig.super.pathWithEdges();
                this.pathWithEdgesBuildStage = 1;
            }
            return this.pathWithEdges;
        }

        void pathWithEdges(boolean pathWithEdges) {
            this.pathWithEdges = pathWithEdges;
            this.pathWithEdgesBuildStage = 1;
        }

        boolean startingVertices() {
            if (this.startingVerticesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.startingVerticesBuildStage == 0) {
                this.startingVerticesBuildStage = -1;
                this.startingVertices = ImmutableCompileConfig.super.startingVertices();
                this.startingVerticesBuildStage = 1;
            }
            return this.startingVertices;
        }

        void startingVertices(boolean startingVertices) {
            this.startingVertices = startingVertices;
            this.startingVerticesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (this.hasPathBuildStage == -1) {
                attributes.add("hasPath");
            }
            if (this.pathWithEdgesBuildStage == -1) {
                attributes.add("pathWithEdges");
            }
            if (this.startingVerticesBuildStage == -1) {
                attributes.add("startingVertices");
            }
            return "Cannot build CompileConfig, attribute initializers form cycle" + attributes;
        }
    }
}

