/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.config;

import com.google.common.collect.Iterables;
import com.sourceclear.api.data.artifact.LibraryArtifactApiModel;
import com.sourceclear.api.data.evidence.Evidence;
import com.sourceclear.api.data.evidence.EvidencePath;
import java.util.EnumSet;

public class Commons {
    public static final float LOW_SEVERITY_THESHOLD = 4.0f;
    public static final float MEDIUM_SEVERITY_THESHOLD = 7.0f;
    public static final int NON_ERROR_VALUE = 0;

    public static Severity determineSeverity(float cvss) {
        Severity severity = cvss < 4.0f ? Severity.Low : (cvss < 7.0f ? Severity.Medium : Severity.High);
        return severity;
    }

    public static Severity determineSeverity(LibraryArtifactApiModel artifact) {
        Float scs = artifact.getSrcclrCvssScore();
        Float ncs = artifact.getNvdCvssScore();
        float cvss = ncs != null ? ncs.floatValue() : (scs != null ? scs.floatValue() : 0.0f);
        return Commons.determineSeverity(cvss);
    }

    public static DependencyMode determineDependencyMode(Evidence evidence) {
        EnumSet<DependencyMode> componentDependencyModes = EnumSet.noneOf(DependencyMode.class);
        for (EvidencePath evidencePath : evidence.getEvidencePaths()) {
            DependencyMode dependencyMode = evidencePath.getDependencyPath().isEmpty() ? DependencyMode.DIRECT : DependencyMode.TRANSITIVE;
            componentDependencyModes.add(dependencyMode);
            if (componentDependencyModes.size() <= 1) continue;
            break;
        }
        return componentDependencyModes.size() == 1 ? (DependencyMode)((Object)Iterables.getOnlyElement(componentDependencyModes)) : DependencyMode.BOTH;
    }

    public static boolean isDirect(Evidence evidence) {
        DependencyMode dependencyMode = Commons.determineDependencyMode(evidence);
        return dependencyMode == DependencyMode.BOTH || dependencyMode == DependencyMode.DIRECT;
    }

    public static enum DependencyMode {
        DIRECT,
        TRANSITIVE,
        BOTH;

    }

    public static enum VulnLevels {
        NEVER(0),
        LOW(-1),
        MEDIUM(-2),
        HIGH(-3),
        METHODS(-4);

        private final int exitValue;

        private VulnLevels(int exitValue) {
            this.exitValue = exitValue;
        }

        public int getExitValue() {
            return this.exitValue;
        }
    }

    public static enum Severity {
        Low,
        Medium,
        High;

    }
}

