/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.config;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;

public final class RepoUtils {
    private static final Pattern LOCAL_PATH_PATTERN = Pattern.compile("(?:file:/{0,2})?/(?<paths>.*)");
    private static final Pattern PROTOCOL_PATTERN = Pattern.compile("(?:.+)/{2}.+?/(?<paths>.+)");
    private static final Pattern DOMAIN_ONLY_PATTERN = Pattern.compile("(?:.+):/?(?<paths>.+)");
    private static final Pattern UNQUALIFIED_PATTERN = Pattern.compile("^(?:.+?)/(?<paths>.*)");
    private static final List<Pattern> PATH_PATTERNS = ImmutableList.of((Object)LOCAL_PATH_PATTERN, (Object)PROTOCOL_PATTERN, (Object)DOMAIN_ONLY_PATTERN, (Object)UNQUALIFIED_PATTERN);

    @Nonnull
    public static Pair<String, String> parseRepoUrl(@Nullable String repoUrl) {
        if (Strings.isNullOrEmpty((String)repoUrl)) {
            return Pair.of(null, null);
        }
        String strippedUrl = null;
        for (Pattern p : PATH_PATTERNS) {
            Matcher m = p.matcher(repoUrl);
            if (!m.matches()) continue;
            strippedUrl = m.group("paths");
            break;
        }
        if (Strings.isNullOrEmpty(strippedUrl)) {
            throw new IllegalArgumentException("Could not match on URL pattern " + repoUrl);
        }
        ArrayList elements = Lists.newArrayList((Object[])strippedUrl.split("/"));
        String name = ((String)elements.remove(elements.size() - 1)).replaceAll("\\.git$", "");
        String path = elements.isEmpty() ? null : Joiner.on((String)"/").join((Iterable)elements);
        return Pair.of((Object)path, (Object)name);
    }

    @Nullable
    public static String scrubURI(@Nullable URI uri) {
        if (uri == null) {
            return null;
        }
        try {
            String userInfo = uri.getUserInfo();
            if (userInfo == null) {
                return uri.toString();
            }
            URI cleaned = new URI(uri.getScheme(), uri.getHost(), uri.getPath(), uri.getFragment());
            return cleaned.toString();
        }
        catch (URISyntaxException e) {
            return uri.toString();
        }
    }

    @Nullable
    public static String scrubURI(@Nullable String repoUri) {
        if (repoUri == null) {
            return null;
        }
        try {
            return RepoUtils.scrubURI(URI.create(repoUri));
        }
        catch (IllegalArgumentException e) {
            return repoUri;
        }
    }

    private RepoUtils() {
    }
}

