/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.match;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.sourceclear.api.data.match.ContainerId_Builder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@JsonDeserialize(builder=Builder.class)
public abstract class ContainerId {
    private static final String TAG = "(\\w[\\w.\\-]*)";
    private static final String NAME = "([^:\\s]+)";
    private static final String TAGGED_NAME = "([^:\\s]+):(\\w[\\w.\\-]*)";
    private static final String NAME_WITH_PORT = "([^:\\s]+):(\\d+)/([^:]+)";
    private static final String TAGGED_NAME_WITH_PORT = "([^:\\s]+):(\\d+)/([^:]+):(\\w[\\w.\\-]*)";
    private static final Pattern TAGGED_NAME_PATTERN = Pattern.compile("^([^:\\s]+):(\\w[\\w.\\-]*)$");
    private static final Pattern TAGGED_NAME_WITH_PORT_PATTERN = Pattern.compile("^([^:\\s]+):(\\d+)/([^:]+):(\\w[\\w.\\-]*)$");

    public abstract String name();

    public abstract String tag();

    public abstract String hash();

    public static Builder parse(String id) {
        try {
            id = ContainerId.removeUrlProtocol(id);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        Matcher taggedImageNameMatcher = TAGGED_NAME_PATTERN.matcher(id);
        if (taggedImageNameMatcher.find()) {
            return new Builder().name(taggedImageNameMatcher.group(1)).tag(taggedImageNameMatcher.group(2));
        }
        if (id.matches(NAME)) {
            return new Builder().name(id).tag("latest");
        }
        Matcher taggedUrlNoProtocolMatcher = TAGGED_NAME_WITH_PORT_PATTERN.matcher(id);
        if (taggedUrlNoProtocolMatcher.find()) {
            return new Builder().name(taggedUrlNoProtocolMatcher.group(1) + ":" + taggedUrlNoProtocolMatcher.group(2) + "/" + taggedUrlNoProtocolMatcher.group(3)).tag(taggedUrlNoProtocolMatcher.group(4));
        }
        if (id.matches(NAME_WITH_PORT)) {
            return new Builder().name(id).tag("latest");
        }
        throw new IllegalArgumentException("could not parse " + id + " as an image repository:tag");
    }

    public String image() {
        return String.format("%s:%s", this.name(), this.tag());
    }

    private static String removeUrlProtocol(String id) throws MalformedURLException {
        URL idAsUrl = new URL(id);
        String host = idAsUrl.getHost();
        String path = idAsUrl.getPath();
        int port = idAsUrl.getPort();
        if (port >= 0) {
            return host + ":" + port + path;
        }
        return host + path;
    }

    public static class Builder
    extends ContainerId_Builder {
        public String image() {
            return String.format("%s:%s", this.name(), this.tag());
        }

        public String id() {
            if (this.name().equals(this.hash())) {
                return this.hash();
            }
            return this.image();
        }
    }
}

