/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.common;

import com.google.common.collect.ImmutableMap;
import com.sourceclear.api.data.analytics.AgentRuntimeData;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import javax.annotation.Nullable;

public class CollectionException
extends Exception {
    private static final long serialVersionUID = -6538707074572983699L;
    private final CollectionErrorType exceptionType;
    private final String outputLog;
    private AgentRuntimeData agentRuntimeData;
    private ImmutableMap<String, Object> scanAttributes;

    public CollectionException(CollectionErrorType exceptionType, String message) {
        this(exceptionType, message, null);
    }

    public CollectionException(CollectionErrorType exceptionType, String message, String outputLog) {
        super(message);
        this.exceptionType = exceptionType;
        this.outputLog = outputLog;
    }

    public CollectionException(CollectionErrorType exceptionType, String message, String outputLog, Throwable cause) {
        super(message, cause);
        this.exceptionType = exceptionType;
        this.outputLog = outputLog;
    }

    @Override
    public CollectionException initCause(Throwable t) {
        super.initCause(t);
        return this;
    }

    public CollectionErrorType getExceptionType() {
        return this.exceptionType;
    }

    public String getErrorLog() {
        return this.outputLog;
    }

    @Nullable
    public AgentRuntimeData getAgentRuntimeData() {
        return this.agentRuntimeData;
    }

    public CollectionException withAgentRuntimeData(AgentRuntimeData agentRuntimeData) {
        this.agentRuntimeData = agentRuntimeData;
        return this;
    }

    @Nullable
    public ImmutableMap<String, Object> getScanAttributes() {
        return this.scanAttributes;
    }

    public CollectionException withScanAttributes(ImmutableMap<String, Object> scanAttributes) {
        this.scanAttributes = scanAttributes;
        return this;
    }
}

