/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.methods;

import com.sourceclear.api.data.methods.MethodCallData;
import com.sourceclear.engine.common.ClassFileVisitor;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.methods.BaseMethodsEngine;
import com.sourceclear.engine.methods.GradleModuleAwareScanBatcher;
import com.sourceclear.engine.methods.MavenModuleAwareScanBatcher;
import com.sourceclear.engine.methods.MethodScanBatcher;
import com.sourceclear.engine.methods.MethodsEngine;
import com.sourceclear.engine.methods.SimpleFileMethodScanBatcher;
import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.MethodScannerFactory;
import com.sourceclear.methods.VulnMethodsConfig;
import com.sourceclear.methods.java.JavaMethodScannerFactory;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ClassMethodsEngine
extends BaseMethodsEngine {
    private final MethodScannerFactory methodScannerFactory = new JavaMethodScannerFactory();
    private Set<CallSite> dynamicEdges = Collections.emptySet();

    @Override
    public MethodsEngine.Result scanMethods(Path scanRoot, Collection<MethodCallData> inputMethodData, LogStream logStream) {
        try {
            return this.innerScanMethods(scanRoot, inputMethodData, logStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MethodsEngine withDynamicEdges(Set<CallSite> edges) {
        this.dynamicEdges = edges;
        return this;
    }

    @Override
    public MethodsEngine withVulnMethodsConfig(VulnMethodsConfig config) {
        this.methodScannerFactory.withVulnMethodsConfig(config);
        return this;
    }

    @Override
    public VulnMethodsConfig.Builder defaultConfig() {
        return this.methodScannerFactory.defaultVulnMethodsConfig().parallel(true);
    }

    @Override
    MethodScanBatcher setupBatcher(Path scanRoot, LogStream logStream) {
        Path pomFile = scanRoot.resolve("pom.xml");
        if (Files.exists(pomFile, new LinkOption[0])) {
            return new MavenModuleAwareScanBatcher(this.methodScannerFactory, logStream);
        }
        Path buildFile = scanRoot.resolve("build.gradle");
        if (Files.exists(buildFile, new LinkOption[0])) {
            return new GradleModuleAwareScanBatcher(this.methodScannerFactory, logStream);
        }
        return new SimpleFileMethodScanBatcher(this.methodScannerFactory, logStream, ClassFileVisitor.getVisitor());
    }

    @Override
    public Set<CallSite> getDynamicEdges() {
        return this.dynamicEdges;
    }
}

