/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods;

import com.carrotsearch.hppc.ObjectDoubleMap;
import com.carrotsearch.hppc.ObjectDoubleScatterMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.GraphTests;
import org.jgrapht.Graphs;
import org.jgrapht.alg.util.Pair;
import org.jgrapht.graph.GraphWalk;

public class SomePairsShortestPaths<V, E> {
    private static final String GRAPH_MUST_CONTAIN_THE_SOURCE_VERTEX = "Graph must contain the source vertex!";
    private static final String GRAPH_MUST_CONTAIN_THE_SINK_VERTEX = "Graph must contain the sink vertex!";
    private final Set<V> startingVertices;
    private final Graph<V, E> graph;
    private ObjectDoubleMap<Coord> distance;
    private Map<Coord, E> pred;
    private Map<V, Integer> vertexIndices;

    public SomePairsShortestPaths(Graph<V, E> graph, Set<V> startingVertices) {
        this.graph = graph;
        this.startingVertices = startingVertices;
        if (!graph.vertexSet().containsAll(startingVertices)) {
            throw new IllegalArgumentException("provided starting set has to be a subset of the graph's vertices");
        }
    }

    public GraphPath<V, E> getPath(V source, V sink) {
        this.checkAndRun(source, sink);
        if (source.equals(sink)) {
            return GraphWalk.singletonWalk(this.graph, source, (double)0.0);
        }
        int vSource = this.vertexIndices.get(source);
        int vSink = this.vertexIndices.get(sink);
        Object cur = sink;
        E e = this.pred.get(new Coord(vSource, vSink));
        if (e == null) {
            return null;
        }
        LinkedList<E> edgeList = new LinkedList<E>();
        while (e != null) {
            edgeList.addFirst(e);
            cur = Graphs.getOppositeVertex(this.graph, e, cur);
            e = this.pred.get(new Coord(vSource, this.vertexIndices.get(cur)));
        }
        return new GraphWalk(this.graph, source, sink, null, edgeList, this.distance.get((Object)new Coord(vSource, vSink)));
    }

    public double getPathWeight(V source, V sink) {
        this.checkAndRun(source, sink);
        return this.distance.get((Object)new Coord(this.vertexIndices.get(source), this.vertexIndices.get(sink)));
    }

    public boolean hasDirectedPath(V source, V sink) {
        return this.getPathWeight(source, sink) < Double.POSITIVE_INFINITY;
    }

    private void runWithPositiveEdgeWeights(Graph<V, E> g) {
        this.vertexIndices = this.computeVertexIndices(g);
        int n = g.vertexSet().size();
        this.distance = new ObjectDoubleScatterMap();
        this.pred = new HashMap<Coord, E>();
        for (V v : this.startingVertices) {
            Map distanceAndPredecessorMap;
            Iterator it;
            try {
                Class<?> c = Class.forName("org.jgrapht.alg.shortestpath.DijkstraClosestFirstIterator");
                Constructor<?> declaredConstructor = c.getDeclaredConstructor(Graph.class, Object.class, Double.TYPE);
                declaredConstructor.setAccessible(true);
                it = (Iterator)declaredConstructor.newInstance(g, v, Double.POSITIVE_INFINITY);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("DijkstraClosestFirstIterator unavailable in this version of JGraphT", e);
            }
            while (it.hasNext()) {
                it.next();
            }
            try {
                distanceAndPredecessorMap = (Map)MethodUtils.invokeMethod((Object)it, (boolean)true, (String)"getDistanceAndPredecessorMap");
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
            for (Object u : g.vertexSet()) {
                Pair pair = distanceAndPredecessorMap.getOrDefault(u, Pair.of((Object)Double.POSITIVE_INFINITY, null));
                this.distance.put((Object)new Coord(this.vertexIndices.get(v), this.vertexIndices.get(u)), ((Double)pair.getFirst()).doubleValue());
                this.pred.put(new Coord(this.vertexIndices.get(v), this.vertexIndices.get(u)), pair.getSecond());
            }
        }
    }

    private Map<V, Integer> computeVertexIndices(Graph<V, E> g) {
        HashMap numbering = new HashMap();
        int num = 0;
        for (Object v : g.vertexSet()) {
            numbering.put(v, num++);
        }
        return numbering;
    }

    private void checkAndRun(V source, V sink) {
        if (!this.graph.containsVertex(source)) {
            throw new IllegalArgumentException(GRAPH_MUST_CONTAIN_THE_SOURCE_VERTEX);
        }
        if (!this.graph.containsVertex(sink)) {
            throw new IllegalArgumentException(GRAPH_MUST_CONTAIN_THE_SINK_VERTEX);
        }
        if (!this.startingVertices.contains(source)) {
            throw new IllegalArgumentException("cannot get path weight of vertex not in provided starting set");
        }
        this.run();
    }

    private void run() {
        if (this.pred != null) {
            return;
        }
        GraphTests.requireDirectedOrUndirected(this.graph);
        this.runWithPositiveEdgeWeights(this.graph);
    }

    private static class Coord {
        private final int x;
        private final int y;

        Coord(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Coord coord = (Coord)o;
            return this.x == coord.x && this.y == coord.y;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y);
        }
    }
}

