/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods.java;

import com.sourceclear.analysis.utils.Utils;
import com.sourceclear.methods.CHACallSite;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.MethodInfoImpl;
import com.sourceclear.methods.java.CallGraphBuilderMethodVisitor;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

class CallGraphClassVisitor
extends ClassVisitor {
    private final int version;
    private final String className;
    private final Set<CHACallSite> callSites = new HashSet<CHACallSite>();

    CallGraphClassVisitor(String className, int version) {
        super(version);
        this.className = className;
        this.version = version;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodInfo caller = MethodInfoImpl.builder().withClassName(this.className).withMethodName(name).withDesc(Utils.stripReturnType(desc)).build();
        return new CallGraphBuilderMethodVisitor(this.version, caller, this.callSites);
    }

    public Set<CHACallSite> getCallSites() {
        return this.callSites;
    }
}

