/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.io;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Strings;
import com.sourceclear.api.data.artifact.LibraryArtifactApiModel;
import com.sourceclear.api.data.artifact.LibraryMatchWithArtifactsApiModel;
import com.sourceclear.api.data.evidence.LibraryInstanceModel;
import com.sourceclear.api.data.evidence.LibraryModel;
import com.sourceclear.util.fingerprints.VersionMatcher;
import com.srcclr.sdk.CoordinateType;
import com.srcclr.sdk.LanguageType;
import com.srcclr.sdk.Library;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryLicense;
import com.srcclr.sdk.LibraryVersion;
import com.srcclr.sdk.Link;
import com.srcclr.sdk.Record;
import com.srcclr.sdk.RecordMetadata;
import com.srcclr.sdk.RecordType;
import com.srcclr.sdk.Report;
import com.srcclr.sdk.ReportMetadata;
import com.srcclr.sdk.Vulnerability;
import com.srcclr.sdk.VulnerabilityLibrary;
import com.srcclr.sdk.VulnerabilityLibraryDetails;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class SdkReportComposer {
    private static final VersionMatcher versionMatcher = new VersionMatcher();
    private static final Comparator<LibraryInstanceModel> releaseDateComparator = Comparator.comparing(LibraryInstanceModel::getReleaseDate, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(LibraryInstanceModel::getId).reversed();
    private final Function<Long, String> libraryUrlGenerator;
    private final Function<Long, String> artifactUrlGenerator;

    @Nullable
    private static LibraryInstanceModel getMatchingLibraryInstance(LibraryModel libraryModel) {
        return libraryModel.getInstances().stream().findFirst().orElse(null);
    }

    @Nullable
    private static String getArtifactCVE(LibraryArtifactApiModel artifact) {
        String cveYear = artifact.getCveYear();
        String cveDigits = artifact.getCveDigits();
        if (!Strings.isNullOrEmpty((String)cveYear) && !Strings.isNullOrEmpty((String)cveDigits)) {
            return String.format("%s-%s", cveYear, cveDigits);
        }
        return null;
    }

    public SdkReportComposer(Function<Long, String> libraryUrlGenerator, Function<Long, String> artifactUrlGenerator) {
        this.libraryUrlGenerator = libraryUrlGenerator;
        this.artifactUrlGenerator = artifactUrlGenerator;
    }

    public Report createSDKReportFromLibrarianMatch(Collection<LibraryMatchWithArtifactsApiModel> matches, Collection<LibraryGraph> graphs, @Nonnull RecordType recordType) {
        Record.Builder recordBuilder = new Record.Builder().withGraphs(graphs);
        RecordMetadata recordMetadata = new RecordMetadata.Builder().withRecordType(recordType).build();
        recordBuilder.withMetadata(recordMetadata);
        TreeMap<LibraryArtifactApiModel, Collection<ComponentAndVersion>> artifactComponentIdMap = new TreeMap<LibraryArtifactApiModel, Collection<ComponentAndVersion>>(Comparator.comparing(LibraryArtifactApiModel::getId));
        MatchList matchList = new MatchList();
        for (LibraryMatchWithArtifactsApiModel match : matches) {
            Pair<LibraryModel, LibraryInstanceModel> librarianMatchData = this.getLibrarianMatchData(match);
            if (librarianMatchData == null) continue;
            LibraryModel libraryModel = (LibraryModel)librarianMatchData.getLeft();
            libraryModel.getInstances().stream().findFirst().ifPresent(instance -> {
                matchList.add(libraryModel, (LibraryInstanceModel)instance);
                match.getArtifacts().forEach(artifact -> {
                    Collection versionsForArtifact = artifactComponentIdMap.computeIfAbsent((LibraryArtifactApiModel)artifact, k -> new HashSet());
                    versionsForArtifact.add(new ComponentAndVersion(libraryModel.getId(), instance.getLibraryVersion()));
                });
            });
        }
        Collection<Library> libraries = matchList.build();
        recordBuilder.withLibraries(libraries);
        this.addVulnsToRecord(recordBuilder, matchList, artifactComponentIdMap);
        return this.createSingleRecordReport(recordBuilder.build());
    }

    @Nullable
    private Pair<LibraryModel, LibraryInstanceModel> getLibrarianMatchData(LibraryMatchWithArtifactsApiModel match) {
        LibraryModel libraryModel = match.getComponent();
        if (libraryModel == null) {
            return null;
        }
        LibraryInstanceModel instance = SdkReportComposer.getMatchingLibraryInstance(libraryModel);
        if (instance == null) {
            return null;
        }
        return Pair.of((Object)libraryModel, (Object)instance);
    }

    private void addVulnsToRecord(Record.Builder recordBuilder, MatchList matchList, Map<LibraryArtifactApiModel, Collection<ComponentAndVersion>> artifactComponentVersionMap) {
        ArrayList vulnerabilities = new ArrayList();
        artifactComponentVersionMap.forEach((artifact, componentVersions) -> {
            ArrayList sortableVulnLibraries = new ArrayList();
            componentVersions.forEach(componentAndVersion -> {
                long componentId = ((ComponentAndVersion)componentAndVersion).componentId;
                String version = ((ComponentAndVersion)componentAndVersion).version;
                artifact.getArtifactComponents().stream().filter(artifactComponent -> artifactComponent.getComponentId() == componentId).flatMap(artifactComponent -> artifactComponent.getVersionRanges().stream()).filter(versionRange -> versionMatcher.matches(versionRange.getVersionRange(), version)).findFirst().ifPresent(versionRange -> {
                    int[] refIndexes = matchList.find((ComponentAndVersion)componentAndVersion);
                    if (refIndexes == null) {
                        return;
                    }
                    int libIdx = refIndexes[0];
                    int versionIdx = refIndexes[1];
                    String ref = String.format("/records/0/libraries/%d/versions/%d", libIdx, versionIdx);
                    Link libraryReferenceLink = new Link("ref", ref);
                    VulnerabilityLibraryDetails vulnerabilityLibraryDetails = new VulnerabilityLibraryDetails.Builder().withFixText(versionRange.getFixText()).withVersionRange(versionRange.getVersionRange()).withUpdateToVersion(versionRange.getUpdateToVersion()).withPatch(versionRange.getPatch()).build();
                    VulnerabilityLibrary vulnLibrary = ((VulnerabilityLibrary.Builder)new VulnerabilityLibrary.Builder().withDetails(Collections.singletonList(vulnerabilityLibraryDetails)).withLinks(Collections.singletonList(libraryReferenceLink))).build();
                    sortableVulnLibraries.add(new SortableVulnLibrary(vulnLibrary, libIdx, versionIdx));
                });
            });
            TreeSet<String> vulnTypes = new TreeSet<String>(artifact.getVulnerabilityTypes());
            String cve = SdkReportComposer.getArtifactCVE(artifact);
            Float cvss = (Float)ObjectUtils.firstNonNull((Object[])new Float[]{artifact.getNvdCvssScore(), artifact.getSrcclrCvssScore()});
            Float cvss3 = artifact.getNvdCvss3Score().orElse(artifact.getSrcclrCvss3Score().orElse(null));
            LanguageType languageType = (LanguageType)EnumUtils.getEnum(LanguageType.class, (String)StringUtils.upperCase((String)artifact.getLanguage()));
            String artifactUrl = this.artifactUrlGenerator.apply(artifact.getId());
            Link artifactHtmlLink = new Link("html", artifactUrl);
            List vulnLibraries = sortableVulnLibraries.stream().sorted().map(sv -> ((SortableVulnLibrary)sv).vulnerabilityLibrary).collect(Collectors.toList());
            Vulnerability vulnerability = ((Vulnerability.Builder)new Vulnerability.Builder().withTitle(artifact.getTitle()).withOverview(artifact.getOverview()).withCve(cve).withCvssScore(cvss).withCvss3Score(cvss3).withLanguage(languageType).withOverview(artifact.getOverview()).withHasExploits(artifact.getHasExploits()).withDisclosureDate(artifact.getDisclosureDate()).withVulnerabilityTypes(vulnTypes).withLinks(Collections.singletonList(artifactHtmlLink))).withLibraries(vulnLibraries).build();
            vulnerabilities.add(vulnerability);
        });
        recordBuilder.withVulnerabilities(vulnerabilities);
    }

    private Report createSingleRecordReport(Record record) {
        ReportMetadata reportMetadata = new ReportMetadata.Builder().withRequestDate(new Date()).build();
        return new Report.Builder().withMetadata(reportMetadata).withRecords(Collections.singletonList(record)).build();
    }

    private class MatchList {
        private final Map<HashLibrary, Set<HashInstance>> map = new TreeMap<HashLibrary, Set<HashInstance>>();
        private LinkedHashMap<Long, Library> libraryMap;
        private Map<ComponentAndVersion, int[]> instanceRefIndexes;

        private MatchList() {
        }

        void add(LibraryModel libraryModel, LibraryInstanceModel instance) {
            if (this.libraryMap != null) {
                throw new IllegalStateException("cannot add new matches after internal data structures already built");
            }
            HashLibrary key = new HashLibrary(libraryModel);
            this.map.computeIfAbsent(key, k -> new TreeSet()).add(new HashInstance(instance));
        }

        @Nullable
        int[] find(ComponentAndVersion componentAndVersion) {
            this.build();
            return this.instanceRefIndexes.get(componentAndVersion);
        }

        Collection<Library> build() {
            if (this.libraryMap == null) {
                this.libraryMap = new LinkedHashMap();
                this.instanceRefIndexes = new HashMap<ComponentAndVersion, int[]>();
                int[] refIndexes = new int[2];
                this.map.forEach((libraryHolder, instanceHolders) -> {
                    LibraryModel libraryModel = ((HashLibrary)libraryHolder).libraryModel;
                    String libraryUrl = (String)SdkReportComposer.this.libraryUrlGenerator.apply(libraryModel.getId());
                    refIndexes[1] = 0;
                    ArrayList libraryVersions = new ArrayList(instanceHolders.size());
                    instanceHolders.stream().map(HashInstance::instance).forEach(instance -> {
                        List libraryLicenses = instance.getLicenseInfoModels().stream().map(licenseInfoModel -> new LibraryLicense.Builder().withName(licenseInfoModel.getName()).withLicense(licenseInfoModel.getLicense()).withRisk(Objects.toString((Object)licenseInfoModel.getRisk(), null)).withSpdxId(licenseInfoModel.getSpdxId()).withFromParentPom(Boolean.valueOf(licenseInfoModel.getGroupId() != null)).build()).sorted(Comparator.comparing(LibraryLicense::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
                        String instanceUrl = String.format("%s?version=%s", libraryUrl, instance.getLibraryVersion());
                        LibraryVersion version = ((LibraryVersion.Builder)new LibraryVersion.Builder().withVersion(instance.getLibraryVersion()).withPlatform(instance.getPlatform()).withBytecodeHash(instance.getBytecodeHash()).withSha1(instance.getSha1()).withSha2(instance.getSha2()).withReleaseDate(instance.getReleaseDate()).withLicenses(libraryLicenses).withLinks(Collections.singletonList(new Link("html", instanceUrl)))).build();
                        libraryVersions.add(version);
                        ComponentAndVersion componentAndVersion = new ComponentAndVersion(libraryModel.getId(), instance.getLibraryVersion());
                        this.instanceRefIndexes.put(componentAndVersion, new int[]{refIndexes[0], refIndexes[1]});
                        refIndexes[1] = refIndexes[1] + 1;
                    });
                    LibraryInstanceModel latestRelease = libraryModel.getLatestRelease();
                    Date latestReleaseDate = latestRelease.getReleaseDate();
                    Library component = ((Library.Builder)new Library.Builder().withName(libraryModel.getName()).withLanguage((LanguageType)EnumUtils.getEnum(LanguageType.class, (String)libraryModel.getLanguageType())).withCoordinateType((CoordinateType)EnumUtils.getEnum(CoordinateType.class, (String)libraryModel.getCoordinateType())).withCoordinate1(libraryModel.getCoordinate1()).withCoordinate2(libraryModel.getCoordinate2()).withAuthor(libraryModel.getAuthor()).withAuthorUrl(libraryModel.getAuthorUrl()).withBugTrackerUrl(libraryModel.getBugTrackerUrl()).withCodeRepoType(libraryModel.getCodeRepoType()).withCodeRepoUrl(libraryModel.getCodeRepoUrl()).withLatestRelease(latestRelease.getLibraryVersion()).withLatestReleaseDate(latestReleaseDate).withDescription(libraryModel.getDescription()).withVersions(libraryVersions).withLinks(Collections.singletonList(new Link("html", libraryUrl)))).build();
                    this.libraryMap.put(libraryModel.getId(), component);
                    refIndexes[0] = refIndexes[0] + 1;
                });
            }
            return this.libraryMap.values();
        }
    }

    private static class SortableVulnLibrary
    implements Comparable<SortableVulnLibrary> {
        private final VulnerabilityLibrary vulnerabilityLibrary;
        private final int libraryIdx;
        private final int versionIdx;

        SortableVulnLibrary(VulnerabilityLibrary vulnerabilityLibrary, int libraryIdx, int versionIdx) {
            this.vulnerabilityLibrary = vulnerabilityLibrary;
            this.libraryIdx = libraryIdx;
            this.versionIdx = versionIdx;
        }

        @Override
        public int compareTo(@Nonnull SortableVulnLibrary o) {
            return Comparator.comparingInt(obj -> obj.libraryIdx).thenComparingInt(obj -> obj.versionIdx).compare(this, o);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SortableVulnLibrary that = (SortableVulnLibrary)o;
            return this.libraryIdx == that.libraryIdx && this.versionIdx == that.versionIdx;
        }

        public int hashCode() {
            return Objects.hash(this.libraryIdx, this.versionIdx);
        }
    }

    private static class ComponentAndVersion {
        private final long componentId;
        private final String version;

        ComponentAndVersion(long componentId, String version) {
            this.componentId = componentId;
            this.version = version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComponentAndVersion that = (ComponentAndVersion)o;
            return this.componentId == that.componentId && Objects.equals(this.version, that.version);
        }

        public int hashCode() {
            return Objects.hash(this.componentId, this.version);
        }
    }

    static class HashInstance
    implements Comparable<HashInstance> {
        private final LibraryInstanceModel instance;

        HashInstance(LibraryInstanceModel instance) {
            this.instance = instance;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HashInstance that = (HashInstance)o;
            return Objects.equals(this.instance.getId(), that.instance.getId());
        }

        public int hashCode() {
            return Objects.hash(this.instance.getId());
        }

        @Override
        public int compareTo(@Nonnull HashInstance o) {
            return releaseDateComparator.compare(this.instance, o.instance);
        }

        LibraryInstanceModel instance() {
            return this.instance;
        }
    }

    static class HashLibrary
    implements Comparable<HashLibrary> {
        private final LibraryModel libraryModel;

        HashLibrary(LibraryModel libraryModel) {
            this.libraryModel = libraryModel;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HashLibrary that = (HashLibrary)o;
            return Objects.equals(this.libraryModel.getId(), that.libraryModel.getId());
        }

        public int hashCode() {
            return Objects.hash(this.libraryModel.getId());
        }

        @Override
        public int compareTo(@Nonnull HashLibrary o) {
            String a = String.format("%s-%d", this.libraryModel.getName(), this.libraryModel.getId());
            String b = String.format("%s-%d", o.libraryModel.getName(), o.libraryModel.getId());
            return a.compareToIgnoreCase(b);
        }
    }

    private static class MappedLinksSerializer
    extends JsonSerializer<Collection<Link>> {
        private MappedLinksSerializer() {
        }

        public void serialize(Collection<Link> links, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            TreeMap<String, String> map = new TreeMap<String, String>();
            for (Link link : links) {
                String rel = link.getRel();
                String href = link.getHref();
                if (!StringUtils.isNotBlank((CharSequence)rel) || !StringUtils.isNotBlank((CharSequence)href)) continue;
                map.put(rel, href);
            }
            gen.writeObject(map);
        }
    }

    public static interface MappedLinksMixIn {
        @JsonSerialize(using=MappedLinksSerializer.class)
        @JsonProperty(value="_links")
        public Collection<Link> getLinks();
    }
}

