/*
 * Decompiled with CFR 0.152.
 */
package com.srcclr.sdk;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryGraphContainer;
import com.srcclr.sdk.LibraryGraphSerializationException;
import com.srcclr.sdk.LibraryGraphSerializer;
import java.io.IOException;
import java.util.Arrays;

public class LibraryGraphContainerDeserializer
extends JsonDeserializer<LibraryGraphContainer> {
    public LibraryGraphContainer deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ObjectCodec codec = jsonParser.getCodec();
        JsonNode node = (JsonNode)codec.readTree(jsonParser);
        JsonNode generationNode = node.get("generation");
        Long generation = generationNode == null ? null : Long.valueOf(generationNode.asLong());
        try {
            LibraryGraphSerializer.checkGeneration(generation);
        }
        catch (LibraryGraphSerializationException e) {
            throw new IOException(e);
        }
        JsonNode graphsNode = node.get("graphs");
        if (graphsNode == null) {
            throw new IOException("Expected a component graph list in the graphs field!");
        }
        LibraryGraph[] graphs = (LibraryGraph[])codec.treeToValue((TreeNode)graphsNode, LibraryGraph[].class);
        return new LibraryGraphContainer.Builder().withGraphs(Arrays.asList(graphs)).build();
    }
}

