/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.exceptions.ImageNotFoundException;
import com.spotify.docker.client.exceptions.ImagePullFailedException;
import com.spotify.docker.client.messages.ProgressMessage;
import com.starburstdata.docker.$internal.org.slf4j.Logger;
import com.starburstdata.docker.$internal.org.slf4j.LoggerFactory;

public class LoggingPullHandler
implements ProgressHandler {
    private static final Logger log = LoggerFactory.getLogger(LoggingPullHandler.class);
    private final String image;

    public LoggingPullHandler(String image) {
        this.image = image;
    }

    @Override
    public void progress(ProgressMessage message) throws DockerException {
        if (message.error() != null) {
            if (message.error().contains("404") || message.error().contains("not found")) {
                throw new ImageNotFoundException(this.image, message.toString());
            }
            throw new ImagePullFailedException(this.image, message.toString());
        }
        log.info("pull {}: {}", (Object)this.image, (Object)message);
    }
}

