/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.spotify.docker.client.ObjectMapperProvider;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.exceptions.DockerTimeoutException;
import com.spotify.docker.client.messages.ProgressMessage;
import com.starburstdata.docker.$internal.com.fasterxml.jackson.core.JsonParser;
import com.starburstdata.docker.$internal.com.fasterxml.jackson.databind.MappingIterator;
import com.starburstdata.docker.$internal.com.google.common.io.ByteStreams;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URI;

class ProgressStream
implements Closeable {
    private final InputStream stream;
    private final MappingIterator<ProgressMessage> iterator;

    ProgressStream(InputStream stream) throws IOException {
        this.stream = stream;
        JsonParser parser = ObjectMapperProvider.objectMapper().getFactory().createParser(stream);
        this.iterator = ObjectMapperProvider.objectMapper().readValues(parser, ProgressMessage.class);
    }

    public boolean hasNextMessage(String method, URI uri) throws DockerException {
        try {
            return this.iterator.hasNextValue();
        }
        catch (SocketTimeoutException e) {
            throw new DockerTimeoutException(method, uri, e);
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
    }

    public ProgressMessage nextMessage(String method, URI uri) throws DockerException {
        try {
            return this.iterator.nextValue();
        }
        catch (SocketTimeoutException e) {
            throw new DockerTimeoutException(method, uri, e);
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
    }

    public void tail(ProgressHandler handler, String method, URI uri) throws DockerException, InterruptedException {
        while (this.hasNextMessage(method, uri)) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            handler.progress(this.nextMessage(method, uri));
        }
    }

    @Override
    public void close() throws IOException {
        ByteStreams.copy(this.stream, ByteStreams.nullOutputStream());
    }
}

