/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.auth;

import com.spotify.docker.client.DockerConfigReader;
import com.spotify.docker.client.ImageRef;
import com.spotify.docker.client.auth.RegistryAuthSupplier;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.RegistryAuth;
import com.spotify.docker.client.messages.RegistryConfigs;
import com.starburstdata.docker.$internal.org.slf4j.Logger;
import com.starburstdata.docker.$internal.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;

public class ConfigFileRegistryAuthSupplier
implements RegistryAuthSupplier {
    private static final Logger log = LoggerFactory.getLogger(ConfigFileRegistryAuthSupplier.class);
    private final DockerConfigReader reader;
    private final Path path;

    public ConfigFileRegistryAuthSupplier() {
        this(new DockerConfigReader());
    }

    public ConfigFileRegistryAuthSupplier(DockerConfigReader reader) {
        this(reader, reader.defaultConfigPath());
    }

    public ConfigFileRegistryAuthSupplier(DockerConfigReader reader, Path path) {
        this.reader = reader;
        this.path = path;
    }

    private boolean configFileExists() {
        File f = this.path.toFile();
        return f.isFile() && f.canRead();
    }

    @Override
    public RegistryAuth authFor(String imageName) throws DockerException {
        if (!this.configFileExists()) {
            return null;
        }
        ImageRef ref = new ImageRef(imageName);
        try {
            RegistryAuth registryAuth = this.reader.fromConfig(this.path, ref.getRegistryUrl());
            if (registryAuth != null) {
                return registryAuth;
            }
            return this.reader.fromConfig(this.path, ref.getRegistryName());
        }
        catch (IllegalArgumentException e) {
            log.debug("Failed first attempt to find auth for {}", (Object)ref.getRegistryUrl(), (Object)e);
            try {
                return this.reader.fromConfig(this.path, ref.getRegistryName());
            }
            catch (IllegalArgumentException e2) {
                log.debug("Failed second attempt to find auth for {}", (Object)ref.getRegistryName(), (Object)e2);
                return null;
            }
            catch (IOException e2) {
                throw new DockerException(e2);
            }
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
    }

    @Override
    public RegistryAuth authForSwarm() throws DockerException {
        return null;
    }

    @Override
    public RegistryConfigs authForBuild() throws DockerException {
        if (!this.configFileExists()) {
            return null;
        }
        try {
            return this.reader.fromConfig(this.path);
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
    }
}

