/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.util.date;

import com.strategicgains.util.TextAdapter;
import com.strategicgains.util.date.DateAdapterConstants;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class DateFormatProcessor
implements TextAdapter<Date> {
    private DateFormat[] inputFormats;
    private DateFormat outputFormat;

    public DateFormatProcessor(String outputFormat, List<String> inputFormats) {
        this(outputFormat, inputFormats.toArray(new String[0]));
    }

    public DateFormatProcessor(String outputFormat, String ... inputFormats) {
        this.outputFormat = new SimpleDateFormat(outputFormat);
        this.outputFormat.setTimeZone(DateAdapterConstants.UNIVERSAL_TIME_ZONE);
        this.inputFormats = new SimpleDateFormat[inputFormats.length];
        for (int i = 0; i < this.inputFormats.length; ++i) {
            this.inputFormats[i] = new SimpleDateFormat(inputFormats[i]);
            this.inputFormats[i].setTimeZone(DateAdapterConstants.UNIVERSAL_TIME_ZONE);
        }
    }

    public DateFormatProcessor(DateFormat outputFormat, DateFormat ... inputFormats) {
        this.outputFormat = (DateFormat)outputFormat.clone();
        this.inputFormats = new DateFormat[inputFormats.length];
        for (int i = 0; i < this.inputFormats.length; ++i) {
            this.inputFormats[i] = (DateFormat)inputFormats[i].clone();
        }
    }

    @Override
    public Date parse(String dateString) throws ParseException {
        Date result = null;
        ParseException lastException = null;
        for (DateFormat format : this.inputFormats) {
            try {
                result = ((DateFormat)format.clone()).parse(dateString);
                lastException = null;
                break;
            }
            catch (ParseException e) {
                if (lastException != null) continue;
                lastException = e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        return result;
    }

    @Override
    public String format(Date date) {
        return ((DateFormat)this.outputFormat.clone()).format(date);
    }
}

