/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.hyperexpress;

import com.strategicgains.hyperexpress.BuilderFactory;
import com.strategicgains.hyperexpress.DefaultResourceFactory;
import com.strategicgains.hyperexpress.ResourceFactoryStrategy;
import com.strategicgains.hyperexpress.builder.DefaultBuilderFactory;
import com.strategicgains.hyperexpress.builder.LinkBuilder;
import com.strategicgains.hyperexpress.builder.RelationshipDefinition;
import com.strategicgains.hyperexpress.builder.TokenBinder;
import com.strategicgains.hyperexpress.builder.TokenResolver;
import com.strategicgains.hyperexpress.domain.Link;
import com.strategicgains.hyperexpress.domain.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class HyperExpress {
    private static final HyperExpress INSTANCE = new HyperExpress();
    private DefaultResourceFactory resourceFactory;
    private RelationshipDefinition relationshipDefinition;
    private ThreadLocal<TokenResolver> tokenResolver;
    private BuilderFactory builderFactory;

    private HyperExpress() {
        this._initialize();
    }

    private void _initialize() {
        this.resourceFactory = new DefaultResourceFactory();
        this.relationshipDefinition = new RelationshipDefinition();
        this.tokenResolver = new ThreadLocal();
        this.builderFactory = new DefaultBuilderFactory();
    }

    public static void builderFactory(BuilderFactory factory) {
        HyperExpress.INSTANCE.builderFactory = factory;
    }

    public static void registerResourceFactoryStrategy(ResourceFactoryStrategy factoryStrategy, String contentType) {
        INSTANCE._registerResourceFactoryStrategy(factoryStrategy, contentType);
    }

    public static Resource createResource(Object object, String contentType) {
        return INSTANCE._createResource(object, contentType);
    }

    public static Collection<Resource> createResources(Collection<?> components, Class<?> componentType, String contentType) {
        return INSTANCE._createResources(components, componentType, contentType);
    }

    public static Class<? extends Resource> getResourceType(String contentType) {
        return INSTANCE._getResourceType(contentType);
    }

    public static Resource createCollectionResource(Collection<?> components, Class<?> componentType, String contentType) {
        return INSTANCE._createCollectionResource(components, componentType, contentType);
    }

    public static Resource createCollectionResource(Collection<?> components, Class<?> componentType, String componentRel, String contentType) {
        return INSTANCE._createCollectionResource(components, componentType, componentRel, contentType);
    }

    public static RelationshipDefinition relationships() {
        return HyperExpress.INSTANCE.relationshipDefinition;
    }

    public static void relationships(RelationshipDefinition relationships) {
        HyperExpress.INSTANCE.relationshipDefinition = relationships;
    }

    public static TokenResolver bind(String token, String value) {
        return INSTANCE._bindToken(token, value);
    }

    public static <T> void tokenBinder(TokenBinder<T> callback) {
        INSTANCE._addTokenBinder(callback);
    }

    public static void clearTokenBindings() {
        INSTANCE._clearTokenBindings();
    }

    public static void reset() {
        INSTANCE._initialize();
    }

    private void _registerResourceFactoryStrategy(ResourceFactoryStrategy factoryStrategy, String contentType) {
        this.resourceFactory.addFactoryStrategy(factoryStrategy, contentType);
    }

    private Resource _createResource(Object object, String contentType) {
        Resource r = this.resourceFactory.createResource(object, contentType);
        this._assignResourceLinks(r, object, object == null ? null : object.getClass());
        return r;
    }

    private Collection<Resource> _createResources(Collection<?> components, Class<?> componentType, String contentType) {
        if (components == null || components.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Resource> resources = new ArrayList<Resource>(components.size());
        Resource childResource = null;
        for (Object component : components) {
            if (Resource.class.isAssignableFrom(component.getClass())) {
                childResource = (Resource)component;
                this._assignResourceLinks(childResource, component, componentType);
                continue;
            }
            childResource = this._createResource(component, contentType);
        }
        return resources;
    }

    private Class<? extends Resource> _getResourceType(String contentType) {
        return this.resourceFactory.getResourceType(contentType);
    }

    private Resource _createCollectionResource(Collection<?> components, Class<?> componentType, String contentType) {
        String componentRel = this.relationshipDefinition.getCollectionRelFor(componentType);
        return this._createCollectionResource(components, componentType, componentRel, contentType);
    }

    private Resource _createCollectionResource(Collection<?> components, Class<?> componentType, String componentRel, String contentType) {
        Resource root = this.resourceFactory.createResource(null, contentType);
        List<LinkBuilder> templates = this.relationshipDefinition.getCollectionLinkBuilders(componentType);
        for (Link link : this._resolveUrlTokens(templates, null, this._acquireTokenResolver())) {
            root.addLink(link, this.relationshipDefinition.isCollectionArrayRel(componentType, link.getRel()));
        }
        root.addNamespaces(this.relationshipDefinition.getNamespaces().values());
        Resource childResource = null;
        if (components == null || components.isEmpty()) {
            root.addResources(componentRel, Collections.EMPTY_LIST);
        } else {
            boolean isResourceCollection = false;
            for (Object component : components) {
                if (isResourceCollection || Resource.class.isAssignableFrom(component.getClass())) {
                    isResourceCollection = true;
                    childResource = (Resource)component;
                    this._assignResourceLinks(childResource, component, componentType);
                } else {
                    childResource = this._createResource(component, contentType);
                }
                root.addResource(componentRel, childResource, true);
            }
        }
        return root;
    }

    private TokenResolver _bindToken(String token, String value) {
        return this._acquireTokenResolver().bind(token, value);
    }

    private <T> TokenResolver _addTokenBinder(TokenBinder<T> callback) {
        return this._acquireTokenResolver().binder(callback);
    }

    private void _clearTokenBindings() {
        TokenResolver tr = this._getTokenResolver();
        if (tr != null) {
            tr.clear();
            this.tokenResolver.remove();
        }
    }

    private TokenResolver _acquireTokenResolver() {
        TokenResolver tr = this._getTokenResolver();
        if (tr == null) {
            tr = this.builderFactory.newTokenResolver();
            this.tokenResolver.set(tr);
        }
        return tr;
    }

    private TokenResolver _getTokenResolver() {
        return this.tokenResolver.get();
    }

    private List<Link> _resolveUrlTokens(Collection<LinkBuilder> linkBuilders, Object object, TokenResolver tokenResolver) {
        ArrayList<Link> links = new ArrayList<Link>(linkBuilders.size());
        for (LinkBuilder linkBuilder : linkBuilders) {
            Link link = linkBuilder.build(object, tokenResolver);
            if (link == null) continue;
            links.add(link);
        }
        return links;
    }

    private void _assignResourceLinks(Resource r, Object object, Class<?> objectType) {
        if (object != null) {
            List<LinkBuilder> linkBuilders = this.relationshipDefinition.getLinkBuilders(objectType);
            for (Link link : this._resolveUrlTokens(linkBuilders, object, this._acquireTokenResolver())) {
                r.addLink(link, this.relationshipDefinition.isArrayRel(objectType, link.getRel()));
            }
        }
        r.addNamespaces(this.relationshipDefinition.getNamespaces().values());
    }
}

