/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.hyperexpress.builder;

import com.strategicgains.hyperexpress.builder.ConditionalLinkBuilder;
import com.strategicgains.hyperexpress.builder.DefaultLinkBuilder;
import com.strategicgains.hyperexpress.builder.TokenResolver;
import com.strategicgains.hyperexpress.domain.Link;
import java.util.ArrayList;
import java.util.List;

public class DefaultConditionalLinkBuilder
extends DefaultLinkBuilder
implements ConditionalLinkBuilder {
    private boolean optional = false;
    private List<String> conditionals = new ArrayList<String>();

    public DefaultConditionalLinkBuilder() {
    }

    public DefaultConditionalLinkBuilder(String urlPattern) {
        super(urlPattern);
    }

    public DefaultConditionalLinkBuilder(DefaultLinkBuilder builder) {
        super(builder);
    }

    public DefaultConditionalLinkBuilder(DefaultConditionalLinkBuilder builder) {
        super(builder);
        this.conditionals = new ArrayList<String>(builder.conditionals);
    }

    @Override
    public void optional() {
        this.optional = true;
    }

    @Override
    public void ifBound(String token) {
        if (token == null) {
            return;
        }
        if (token.startsWith("{") && token.endsWith("}")) {
            this.conditionals.add(token);
        } else {
            this.conditionals.add("{" + token + "}");
        }
    }

    @Override
    public void ifNotBound(String token) {
        if (token == null) {
            return;
        }
        if (token.startsWith("{") && token.endsWith("}")) {
            this.conditionals.add("!" + token);
        } else {
            this.conditionals.add("!{" + token + "}");
        }
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public boolean hasConditionals() {
        return this.conditionals != null && !this.conditionals.isEmpty();
    }

    @Override
    public List<String> getConditionals() {
        return this.conditionals;
    }

    @Override
    public Link build(Object object, TokenResolver tokenResolver) {
        Link link = super.build(object, tokenResolver);
        if (this.hasConditionals()) {
            for (String conditional : this.conditionals) {
                String value = tokenResolver.resolve(conditional, object);
                if (value.startsWith("{") && value.endsWith("}") || value.trim().equalsIgnoreCase(Boolean.FALSE.toString())) {
                    return null;
                }
                if (!value.startsWith("!") || value.startsWith("!{") && value.endsWith("}") || value.substring(1).trim().equalsIgnoreCase(Boolean.FALSE.toString())) continue;
                return null;
            }
        } else if (this.isOptional() && link.hasToken()) {
            return null;
        }
        return link;
    }

    @Override
    public Link build() {
        Link link = super.build();
        if (this.isOptional() && link.hasToken()) {
            return null;
        }
        return link;
    }

    @Override
    public Link build(TokenResolver tokenResolver) {
        Link link = super.build(tokenResolver);
        if (this.isOptional() && link.hasToken()) {
            return null;
        }
        return link;
    }
}

