/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.hyperexpress.builder;

import com.strategicgains.hyperexpress.annotation.AnnotationTokenBinder;
import com.strategicgains.hyperexpress.builder.TokenBinder;
import com.strategicgains.hyperexpress.builder.TokenResolver;
import com.strategicgains.hyperexpress.util.MapStringFormat;
import com.strategicgains.hyperexpress.util.Strings;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultTokenResolver
implements TokenResolver {
    private static final MapStringFormat FORMATTER = new MapStringFormat();
    private Map<String, String> values = new HashMap<String, String>();
    private Map<String, Set<String>> multiValues = new HashMap<String, Set<String>>();
    private List<TokenBinder<?>> binders = new ArrayList();
    private boolean bindAnnotations = false;

    public DefaultTokenResolver() {
        this(false);
    }

    public DefaultTokenResolver(boolean bindAnnotations) {
        this.bindAnnotations = bindAnnotations;
        this.initialize();
    }

    private void initialize() {
        if (this.bindAnnotations) {
            this.binder((TokenBinder)AnnotationTokenBinder.instance());
        }
    }

    @Override
    public DefaultTokenResolver bind(String tokenName, String value) {
        if (value == null) {
            this.remove(tokenName);
        } else {
            this.values.put(tokenName, value);
        }
        return this;
    }

    @Override
    public DefaultTokenResolver bind(String tokenName, String ... multiValues) {
        if (multiValues == null || multiValues.length == 0) {
            this.remove(tokenName);
        } else {
            this.bind(tokenName, (List)Arrays.asList(multiValues));
        }
        return this;
    }

    @Override
    public DefaultTokenResolver bind(String tokenName, List<String> multiValues) {
        if (multiValues == null || multiValues.isEmpty()) {
            this.remove(tokenName);
        } else {
            this.bind(tokenName, multiValues.get(0));
            this.bindExtras(tokenName, multiValues);
        }
        return this;
    }

    private void bindExtras(String tokenName, List<String> valueList) {
        if (valueList.size() <= 1) {
            this.multiValues.remove(tokenName);
        } else {
            Set<String> extras = this.multiValues.get(tokenName);
            if (extras == null) {
                extras = new LinkedHashSet<String>(valueList.size() - 1);
                this.multiValues.put(tokenName, extras);
            }
            for (int i = 1; i < valueList.size(); ++i) {
                extras.add(valueList.get(i));
            }
        }
    }

    @Override
    public void clear() {
        this.values.clear();
        this.multiValues.clear();
    }

    @Override
    public void remove(String tokenName) {
        this.values.remove(tokenName);
        this.multiValues.remove(tokenName);
    }

    @Override
    public <T> DefaultTokenResolver binder(TokenBinder<T> callback) {
        if (callback == null) {
            return this;
        }
        this.binders.add(callback);
        return this;
    }

    @Override
    public void clearBinders() {
        this.binders.clear();
        this.initialize();
    }

    @Override
    public void reset() {
        this.clear();
        this.clearBinders();
    }

    @Override
    public String resolve(String pattern) {
        return FORMATTER.format(pattern, this.values);
    }

    @Override
    public String[] resolveMulti(String pattern) {
        ArrayList<String> resolved = new ArrayList<String>();
        String current = FORMATTER.format(pattern, this.values);
        resolved.add(current);
        for (Map.Entry<String, Set<String>> entry : this.multiValues.entrySet()) {
            String firstValue = this.values.get(entry.getKey());
            Iterator<String> nextValue = entry.getValue().iterator();
            while (nextValue.hasNext()) {
                this.values.put(entry.getKey(), nextValue.next());
                String bound = FORMATTER.format(pattern, this.values);
                if (Strings.hasToken(bound)) continue;
                resolved.add(bound);
            }
            this.values.put(entry.getKey(), firstValue);
        }
        return resolved.toArray(new String[0]);
    }

    @Override
    public String resolve(String pattern, Object object) {
        if (object != null) {
            this.callTokenBinders(object);
        }
        return FORMATTER.format(pattern, this.values);
    }

    @Override
    public Collection<String> resolve(Collection<String> patterns) {
        ArrayList<String> resolved = new ArrayList<String>(patterns.size());
        for (String pattern : patterns) {
            resolved.add(this.resolve(pattern));
        }
        return resolved;
    }

    @Override
    public Collection<String> resolve(Collection<String> patterns, Object object) {
        if (object != null) {
            this.callTokenBinders(object);
        }
        return this.resolve(patterns);
    }

    private void callTokenBinders(Object object) {
        if (object == null) {
            return;
        }
        for (TokenBinder<?> tokenBinder : this.binders) {
            Class binderClass = (Class)((ParameterizedType)tokenBinder.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
            if (!binderClass.isAssignableFrom(object.getClass())) continue;
            tokenBinder.bind(object, this);
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("{");
        s.append("bindAnnotations=");
        s.append(this.bindAnnotations);
        for (Map.Entry<String, String> entry : this.values.entrySet()) {
            s.append(", ");
            s.append(entry.getKey());
            s.append("=");
            s.append(entry.getValue());
        }
        return s.toString();
    }
}

