/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.hyperexpress.builder;

import com.strategicgains.hyperexpress.builder.TokenResolver;
import com.strategicgains.hyperexpress.builder.UrlBuilder;
import com.strategicgains.hyperexpress.util.Strings;
import java.util.ArrayList;
import java.util.List;

public class DefaultUrlBuilder
implements UrlBuilder {
    private String baseUrl;
    private String urlPattern;
    private List<String> queries;

    public DefaultUrlBuilder() {
    }

    public DefaultUrlBuilder(String urlPattern) {
        this();
        if (urlPattern == null) {
            throw new NullPointerException("URL Pattern cannot be null using this constructor. Use the no-argument constructor, UrlBuilder().");
        }
        this.urlPattern = urlPattern;
    }

    @Override
    public DefaultUrlBuilder urlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
        return this;
    }

    @Override
    public String urlPattern() {
        return this.urlPattern;
    }

    @Override
    public DefaultUrlBuilder baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    @Override
    public String baseUrl() {
        return this.baseUrl;
    }

    @Override
    public DefaultUrlBuilder withQuery(String query) {
        this.queries().add(query);
        return this;
    }

    @Override
    public void clearQueries() {
        if (this.queries != null) {
            this.queries.clear();
        }
    }

    @Override
    public DefaultUrlBuilder clone() {
        DefaultUrlBuilder b = new DefaultUrlBuilder(this.urlPattern);
        b.baseUrl = this.baseUrl;
        b.queries = this.queries == null ? null : new ArrayList<String>(this.queries);
        return b;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("baseUrl: ");
        s.append(this.baseUrl == null ? "null" : this.baseUrl);
        s.append(", urlPattern: ");
        s.append(this.urlPattern == null ? "null" : this.urlPattern);
        this.printQueryStrings(s);
        return s.toString();
    }

    @Override
    public String build() {
        return this.build(null);
    }

    @Override
    public String build(TokenResolver tokenResolver) {
        return this.build(this.buildFullUrlPattern(), null, tokenResolver);
    }

    @Override
    public String build(Object object, TokenResolver tokenResolver) {
        return this.build(this.buildFullUrlPattern(), object, tokenResolver);
    }

    @Override
    public String build(String urlPattern, TokenResolver tokenResolver) {
        return this.build(urlPattern, null, tokenResolver);
    }

    @Override
    public String build(String urlPattern, Object object, TokenResolver tokenResolver) {
        if (tokenResolver == null) {
            return this.appendQueryString(urlPattern, null);
        }
        String url = tokenResolver.resolve(urlPattern, object);
        return this.appendQueryString(url, tokenResolver);
    }

    private String buildFullUrlPattern() {
        if (this.urlPattern == null) {
            throw new IllegalStateException("Null URL pattern");
        }
        return this.baseUrl == null ? this.urlPattern : this.baseUrl + this.urlPattern;
    }

    private String appendQueryString(String url, TokenResolver tokenResolver) {
        if (this.queries == null || this.queries.isEmpty()) {
            return url;
        }
        StringBuilder sb = new StringBuilder(url);
        boolean hasQuery = url.contains("?");
        for (String query : this.queries) {
            String boundQuery = null;
            boundQuery = Strings.hasToken(query) ? this.resolveQueryString(query, tokenResolver) : query;
            if (boundQuery == null) continue;
            sb.append(this.queryDelimiter(hasQuery));
            sb.append(boundQuery);
            hasQuery = true;
        }
        return hasQuery ? sb.toString() : url;
    }

    private String resolveQueryString(String query, TokenResolver tokenResolver) {
        if (tokenResolver != null) {
            String[] resolved = tokenResolver.resolveMulti(query);
            String all = Strings.join(this.queryDelimiter(true), resolved);
            return Strings.hasToken(all) ? null : all;
        }
        return null;
    }

    private String queryDelimiter(boolean hasQuery) {
        return hasQuery ? "&" : "?";
    }

    private void printQueryStrings(StringBuilder s) {
        boolean isFirst = true;
        s.append("}, query-strings: {");
        if (this.queries != null) {
            for (String query : this.queries) {
                if (!isFirst) {
                    s.append(", ");
                } else {
                    isFirst = false;
                }
                s.append(query);
            }
        }
        s.append("}");
    }

    private List<String> queries() {
        if (this.queries == null) {
            this.queries = new ArrayList<String>();
        }
        return this.queries;
    }
}

