/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.hyperexpress.builder;

import com.strategicgains.hyperexpress.BuilderFactory;
import com.strategicgains.hyperexpress.builder.ConditionalLinkBuilder;
import com.strategicgains.hyperexpress.builder.DefaultBuilderFactory;
import com.strategicgains.hyperexpress.builder.LinkBuilder;
import com.strategicgains.hyperexpress.domain.Namespace;
import com.strategicgains.hyperexpress.exception.RelationshipException;
import com.strategicgains.hyperexpress.util.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RelationshipDefinition {
    private static final String COLLECTION_SUFFIX = ".Collection";
    private static final String TITLE = "title";
    private static final String TYPE = "type";
    private static final String HREFLANG = "hreflang";
    private static final String TEMPLATED = "templated";
    private static final String DEPRECATION = "deprecation";
    private static final String NAME = "name";
    private static final String PROFILE = "profile";
    private static final String LENGTH = "length";
    private BuilderFactory factory = new DefaultBuilderFactory();
    private Map<String, Namespace> namespaces = new LinkedHashMap<String, Namespace>();
    private Map<String, Set<String>> arrayRelsByClass = new HashMap<String, Set<String>>();
    private Map<String, List<ConditionalLinkBuilder>> linkBuildersByClass = new LinkedHashMap<String, List<ConditionalLinkBuilder>>();
    private List<ConditionalLinkBuilder> linkBuildersForClass;
    private ConditionalLinkBuilder linkBuilder;
    private Set<String> arrayRels;
    private String lastClassName;
    private Map<String, String> relNamesByClass = new HashMap<String, String>();

    public RelationshipDefinition builderFactory(BuilderFactory factory) {
        this.factory = factory;
        return this;
    }

    public RelationshipDefinition addNamespaces(Namespace ... namespaces) {
        if (namespaces == null) {
            return this;
        }
        for (Namespace namespace : namespaces) {
            this.addNamespace(namespace);
        }
        return this;
    }

    public RelationshipDefinition addNamespace(Namespace namespace) {
        if (namespace == null) {
            return this;
        }
        if (this.namespaces.containsKey(namespace.name())) {
            throw new RelationshipException("Duplicate namespace: " + namespace.name());
        }
        this.namespaces.put(namespace.name(), namespace.clone());
        return this;
    }

    public RelationshipDefinition forCollectionOf(Class<?> forClass) {
        if (forClass == null) {
            return this;
        }
        return this.forClassName(forClass.getName() + COLLECTION_SUFFIX);
    }

    public RelationshipDefinition asRel(String name) {
        if (this.lastClassName == null) {
            throw new RelationshipException("Attempt to call asRel() before forCollectionOf()");
        }
        this.relNamesByClass.put(this.lastClassName, name);
        return this;
    }

    public String getCollectionRelFor(Class<?> forClass) {
        String rel = this.relNamesByClass.get(forClass.getName() + COLLECTION_SUFFIX);
        if (rel == null) {
            rel = Strings.pluralize(forClass.getSimpleName().toLowerCase());
        }
        return rel;
    }

    public RelationshipDefinition forClass(Class<?> forClass) {
        if (forClass == null) {
            return this;
        }
        return this.forClassName(forClass.getName());
    }

    private RelationshipDefinition forClassName(String name) {
        if (name == null) {
            return this;
        }
        this.lastClassName = name;
        this.linkBuildersForClass = this.linkBuildersByClass.get(name);
        if (this.linkBuildersForClass == null) {
            this.linkBuildersForClass = new ArrayList<ConditionalLinkBuilder>();
            this.linkBuildersByClass.put(name, this.linkBuildersForClass);
        }
        this.arrayRels = this.arrayRelsByClass.get(name);
        if (this.arrayRels == null) {
            this.arrayRels = new HashSet<String>();
            this.arrayRelsByClass.put(name, this.arrayRels);
        }
        return this;
    }

    public RelationshipDefinition rel(String rel, String href) {
        return this.rel(rel, this.factory.newLinkBuilder(href));
    }

    public RelationshipDefinition rel(String rel, ConditionalLinkBuilder builder) {
        builder.rel(rel);
        this.linkBuilder = builder;
        if (this.linkBuildersForClass == null) {
            throw new RelationshipException("Attempt to call rel() before forClass() or forCollectionOf()");
        }
        this.linkBuildersForClass.add(builder);
        return this;
    }

    public RelationshipDefinition rels(String name, String href) {
        return this.rels(name, this.factory.newLinkBuilder(href));
    }

    public RelationshipDefinition rels(String name, ConditionalLinkBuilder builder) {
        this.arrayRels.add(name);
        return this.rel(name, builder);
    }

    public RelationshipDefinition title(String title) {
        return this.attribute(TITLE, title);
    }

    public RelationshipDefinition hreflang(String value) {
        return this.attribute(HREFLANG, value);
    }

    public RelationshipDefinition type(String type) {
        return this.attribute(TYPE, type);
    }

    public RelationshipDefinition name(String name) {
        return this.attribute(NAME, name);
    }

    public RelationshipDefinition templated(boolean value) {
        if (value) {
            return this.attribute(TEMPLATED, Boolean.TRUE.toString());
        }
        return this.attribute(TEMPLATED, null);
    }

    public RelationshipDefinition deprecation(String value) {
        return this.attribute(DEPRECATION, value);
    }

    public RelationshipDefinition profile(String value) {
        return this.attribute(PROFILE, value);
    }

    public RelationshipDefinition length(String value) {
        return this.attribute(LENGTH, value);
    }

    public RelationshipDefinition optional() {
        if (this.linkBuilder == null) {
            throw new RelationshipException("Attempt to set optional on null link. Call 'rel()' first.");
        }
        this.linkBuilder.optional();
        return this;
    }

    public RelationshipDefinition ifBound(String token) {
        if (this.linkBuilder == null) {
            throw new RelationshipException("Attempt to set ifBound() on null link: " + token + ". Call 'rel()' first.");
        }
        this.linkBuilder.ifBound(token);
        return this;
    }

    public RelationshipDefinition ifNotBound(String token) {
        if (this.linkBuilder == null) {
            throw new RelationshipException("Attempt to set ifNotBound() on null link: " + token + ". Call 'rel()' first.");
        }
        this.linkBuilder.ifNotBound(token);
        return this;
    }

    public RelationshipDefinition attribute(String name, String value) {
        if (this.linkBuilder == null) {
            throw new RelationshipException("Attempt to set attribute on null link: " + name + ". Call 'rel()' first.");
        }
        this.linkBuilder.set(name, value);
        return this;
    }

    public RelationshipDefinition withQuery(String querySegment) {
        if (this.linkBuilder == null) {
            throw new RelationshipException("Attempt to set query-string segment on null link: " + querySegment + ". Call 'rel()' first.");
        }
        this.linkBuilder.withQuery(querySegment);
        return this;
    }

    public List<LinkBuilder> getLinkBuilders(Class<?> forClass) {
        if (forClass == null) {
            return Collections.emptyList();
        }
        if (forClass.isArray()) {
            return this.getLinkBuildersForName(forClass.getComponentType().getName() + COLLECTION_SUFFIX);
        }
        return this.getLinkBuildersForName(forClass.getName());
    }

    public List<LinkBuilder> getCollectionLinkBuilders(Class<?> componentType) {
        if (componentType == null) {
            return Collections.emptyList();
        }
        return this.getLinkBuildersForName(componentType.getName() + COLLECTION_SUFFIX);
    }

    public Map<String, Namespace> getNamespaces() {
        return Collections.unmodifiableMap(this.namespaces);
    }

    public boolean isArrayRel(Class<?> objectType, String rel) {
        return this.isArrayRel(objectType.getName(), rel);
    }

    public boolean isCollectionArrayRel(Class<?> objectType, String rel) {
        return this.isArrayRel(objectType.getName() + COLLECTION_SUFFIX, rel);
    }

    private boolean isArrayRel(String className, String rel) {
        Set<String> rels = this.arrayRelsByClass.get(className);
        return rels == null ? false : rels.contains(rel);
    }

    private List<LinkBuilder> getLinkBuildersForName(String className) {
        List<ConditionalLinkBuilder> builders = this.linkBuildersByClass.get(className);
        return builders != null ? Collections.unmodifiableList(builders) : Collections.emptyList();
    }
}

