/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.hyperexpress.domain;

import com.strategicgains.hyperexpress.domain.Link;
import com.strategicgains.hyperexpress.util.Strings;
import java.util.HashMap;
import java.util.Map;

public class LinkDefinition
implements Link {
    private static final String REL_TYPE = "rel";
    private static final String HREF = "href";
    private Map<String, String> attributes = new HashMap<String, String>();

    public LinkDefinition(String rel, String href) {
        this.setRel(rel);
        this.setHref(href);
    }

    public LinkDefinition(LinkDefinition that) {
        if (that != null) {
            this.attributes.putAll(that.attributes);
        }
    }

    @Override
    public LinkDefinition clone() {
        return new LinkDefinition(this);
    }

    @Override
    public String getHref() {
        return this.get(HREF);
    }

    @Override
    public LinkDefinition setHref(String href) {
        this.set(HREF, href);
        return this;
    }

    @Override
    public String getRel() {
        return this.get(REL_TYPE);
    }

    @Override
    public LinkDefinition setRel(String rel) {
        this.set(REL_TYPE, rel);
        return this;
    }

    @Override
    public LinkDefinition set(String name, String value) {
        if (value == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, value);
        }
        return this;
    }

    @Override
    public String get(String name) {
        return this.attributes.get(name);
    }

    @Override
    public boolean has(String name) {
        return this.get(name) != null;
    }

    @Override
    public boolean hasToken() {
        return Strings.hasToken(this.getHref());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.getClass().getSimpleName());
        s.append("{");
        boolean isFirst = true;
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            if (!isFirst) {
                s.append(", ");
            } else {
                isFirst = false;
            }
            s.append(entry.getKey());
            s.append("=");
            s.append(entry.getValue());
        }
        s.append("}");
        return s.toString();
    }

    public int hashCode() {
        return 31 + (this.attributes == null ? 0 : this.attributes.hashCode());
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        return this.equals((LinkDefinition)that);
    }

    public boolean equals(LinkDefinition that) {
        return !(this.attributes == null ? that.attributes != null : !this.attributes.equals(that.attributes));
    }
}

