/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.hyperexpress.domain.hal;

import com.strategicgains.hyperexpress.domain.Link;
import com.strategicgains.syntaxe.annotation.RegexValidation;
import com.strategicgains.syntaxe.annotation.Required;
import java.util.regex.Pattern;

public class HalLink {
    public static final String TYPE = "type";
    public static final String TITLE = "title";
    public static final String TEMPLATED = "templated";
    public static final String PROFILE = "profile";
    public static final String NAME = "name";
    public static final String HREFLANG = "hreflang";
    public static final String HREF = "href";
    public static final String DEPRECATION = "deprecation";
    private static final String TEMPLATE_REGEX = "\\{(\\w*?)\\}";
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("\\{(\\w*?)\\}");
    @Required
    private String href;
    private String name;
    @RegexValidation(pattern="[A-Za-z]{1,8}(-[A-Za-z0-9]{1,8})*", nullable=true, message="MUST be a language tag [RFC3066]")
    private String hreflang;
    private String title;
    private Boolean templated;
    private String type;
    private String deprecation;
    private String profile;

    public HalLink() {
    }

    public HalLink(Link that) {
        this();
        this.setHref(that.getHref());
        this.setDeprecation(that.get(DEPRECATION));
        this.setHreflang(that.get(HREFLANG));
        this.setName(that.get(NAME));
        this.setProfile(that.get(PROFILE));
        this.setTemplated(that.has(TEMPLATED) ? Boolean.valueOf(that.get(TEMPLATED)) : null);
        this.setTitle(that.get(TITLE));
        this.setType(that.get(TYPE));
    }

    public String getHref() {
        return this.href;
    }

    public HalLink setHref(String href) {
        this.href = href;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public HalLink setName(String name) {
        this.name = name;
        return this;
    }

    public String getHreflang() {
        return this.hreflang;
    }

    public HalLink setHreflang(String hreflang) {
        this.hreflang = hreflang;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public HalLink setTitle(String title) {
        this.title = title;
        return this;
    }

    public Boolean getTemplated() {
        return this.templated;
    }

    public boolean hasTemplate() {
        return TEMPLATE_PATTERN.matcher(this.getHref()).find();
    }

    public HalLink setTemplated(Boolean templated) {
        this.templated = templated;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public HalLink setType(String type) {
        this.type = type;
        return this;
    }

    public String getDeprecation() {
        return this.deprecation;
    }

    public HalLink setDeprecation(String deprecation) {
        this.deprecation = deprecation;
        return this;
    }

    public String getProfile() {
        return this.profile;
    }

    public HalLink setProfile(String profile) {
        this.profile = profile;
        return this;
    }
}

