/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.hyperexpress.serialization.siren.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.strategicgains.hyperexpress.BuilderFactory;
import com.strategicgains.hyperexpress.builder.ConditionalLinkBuilder;
import com.strategicgains.hyperexpress.builder.DefaultBuilderFactory;
import com.strategicgains.hyperexpress.domain.siren.SirenResource;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class SirenResourceDeserializer
extends JsonDeserializer<SirenResource> {
    private static final String CLASS = "class";
    private static final String TITLE = "title";
    private static final String PROPERTIES = "properties";
    private static final String ENTITIES = "entities";
    private static final String LINKS = "links";
    private static final String ACTIONS = "actions";
    private static final String FIELDS = "fields";
    private BuilderFactory factory;

    public SirenResourceDeserializer() {
        this.factory = new DefaultBuilderFactory();
    }

    public SirenResourceDeserializer(BuilderFactory factory) {
        this.factory = factory;
    }

    public SirenResource deserialize(JsonParser jp, DeserializationContext context) throws IOException, JsonProcessingException {
        ObjectCodec oc = jp.getCodec();
        return this.deserializeResource((JsonNode)jp.readValueAsTree(), oc);
    }

    private SirenResource deserializeResource(JsonNode root, ObjectCodec oc) throws JsonProcessingException, IOException {
        SirenResource resource = new SirenResource();
        this.processClass(root.get(CLASS), resource, oc);
        this.processTitle(root.get(TITLE), resource, oc);
        this.processLinks(root.get(LINKS), resource, oc);
        this.processEntities(root.get(ENTITIES), resource, oc);
        this.processProperties(root.get(PROPERTIES), resource);
        this.processActions(root.get(ACTIONS), resource, oc);
        return resource;
    }

    private void processClass(JsonNode jsonNode, SirenResource resource, ObjectCodec oc) {
    }

    private void processTitle(JsonNode jsonNode, SirenResource resource, ObjectCodec oc) {
    }

    private void processLinks(JsonNode links, SirenResource resource, ObjectCodec oc) throws JsonProcessingException, IOException {
        if (links == null) {
            return;
        }
        Iterator fields = links.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            if (((JsonNode)field.getValue()).isArray()) {
                this.addAllLinks(resource, field);
                continue;
            }
            this.addLink(resource, field);
        }
    }

    private void addAllLinks(SirenResource resource, Map.Entry<String, JsonNode> field) {
        ConditionalLinkBuilder lb = this.factory.newLinkBuilder();
        lb.rel(field.getKey());
        Iterator values = field.getValue().elements();
        while (values.hasNext()) {
            JsonNode value = (JsonNode)values.next();
            Iterator elements = value.elements();
            while (elements.hasNext()) {
                JsonNode element = (JsonNode)elements.next();
                lb.set(element.asText(), element.textValue());
            }
            resource.addLink(lb.build());
            lb.clearAttributes();
        }
    }

    private void addLink(SirenResource resource, Map.Entry<String, JsonNode> field) {
        ConditionalLinkBuilder lb = this.factory.newLinkBuilder();
        lb.rel(field.getKey());
        Iterator elements = field.getValue().fields();
        while (elements.hasNext()) {
            Map.Entry element = (Map.Entry)elements.next();
            if ("href".equals(element.getKey())) {
                lb.urlPattern(((JsonNode)element.getValue()).asText());
                continue;
            }
            lb.set((String)element.getKey(), ((JsonNode)element.getValue()).asText());
        }
        resource.addLink(lb.build());
    }

    private void processEntities(JsonNode embedded, SirenResource resource, ObjectCodec oc) throws JsonProcessingException, IOException {
        if (embedded == null) {
            return;
        }
        Iterator fields = embedded.fields();
        while (fields.hasNext()) {
            Map.Entry fieldEntry = (Map.Entry)fields.next();
            if (((JsonNode)fieldEntry.getValue()).isArray()) {
                Iterator values = ((JsonNode)fieldEntry.getValue()).elements();
                while (values.hasNext()) {
                    JsonNode value = (JsonNode)values.next();
                    resource.addResource((String)fieldEntry.getKey(), this.deserializeResource(value, oc));
                }
                continue;
            }
            resource.addResource((String)fieldEntry.getKey(), this.deserializeResource((JsonNode)fieldEntry.getValue(), oc));
        }
    }

    private void processProperties(JsonNode root, SirenResource resource) {
        Iterator fields = root.fields();
        while (fields.hasNext()) {
            Map.Entry fieldEntry = (Map.Entry)fields.next();
            resource.setProperty((String)fieldEntry.getKey(), ((JsonNode)fieldEntry.getValue()).asText());
        }
    }

    private void processActions(JsonNode jsonNode, SirenResource resource, ObjectCodec oc) {
    }
}

