/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.hyperexpress.serialization.siren.jackson;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.strategicgains.hyperexpress.domain.Link;
import com.strategicgains.hyperexpress.domain.Resource;
import com.strategicgains.hyperexpress.domain.siren.SirenAction;
import com.strategicgains.hyperexpress.domain.siren.SirenField;
import com.strategicgains.hyperexpress.domain.siren.SirenLink;
import com.strategicgains.hyperexpress.domain.siren.SirenResource;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SirenResourceSerializer
extends JsonSerializer<SirenResource> {
    private static final String CLASS = "class";
    private static final String TITLE = "title";
    private static final String PROPERTIES = "properties";
    private static final String ENTITIES = "entities";
    private static final String LINKS = "links";
    private static final String ACTIONS = "actions";
    private static final String NAME = "name";
    private static final String METHOD = "method";
    private static final String HREF = "href";
    private static final String TYPE = "type";
    private static final String FIELDS = "fields";

    public void serialize(SirenResource resource, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        jgen.writeStartObject();
        this.renderJson(resource, jgen);
        jgen.writeEndObject();
    }

    private void renderJson(SirenResource resource, JsonGenerator jgen) throws JsonGenerationException, IOException {
        this.writeClass(resource.getClasses(), jgen);
        this.writeTitle(resource.getTitle(), jgen);
        this.writeLinks(resource, jgen);
        this.writeEntities(resource, jgen);
        this.writeProperties(resource.getProperties(), jgen);
        this.writeActions(resource.getActions(), jgen);
    }

    private void writeClass(Collection<String> classes, JsonGenerator jgen) throws IOException {
        if (classes != null && !classes.isEmpty()) {
            jgen.writeArrayFieldStart(CLASS);
            jgen.writeObject(classes);
            jgen.writeEndArray();
        }
    }

    private void writeTitle(String title, JsonGenerator jgen) throws IOException {
        if (title != null && !title.isEmpty()) {
            jgen.writeObjectFieldStart(TITLE);
            jgen.writeObject((Object)title);
            jgen.writeEndObject();
        }
    }

    private void writeLinks(SirenResource resource, JsonGenerator jgen) throws JsonGenerationException, IOException {
        List links = resource.getLinks();
        if (links.isEmpty()) {
            return;
        }
        jgen.writeArrayFieldStart(LINKS);
        Map<String, SirenLink> linksByRel = this.indexLinksByHref(resource.getLinks());
        for (SirenLink link : linksByRel.values()) {
            jgen.writeObject((Object)link);
        }
        jgen.writeEndArray();
    }

    private Map<String, SirenLink> indexLinksByHref(List<Link> links) {
        LinkedHashMap<String, SirenLink> linksByHref = new LinkedHashMap<String, SirenLink>();
        for (Link link : links) {
            SirenLink linkForHref = (SirenLink)linksByHref.get(link.getHref());
            if (linkForHref == null) {
                linkForHref = new SirenLink(link);
                linksByHref.put(link.getHref(), linkForHref);
                continue;
            }
            linkForHref.addRel(link.getRel());
        }
        return linksByHref;
    }

    private void writeEntities(Resource resource, JsonGenerator jgen) throws JsonGenerationException, IOException {
        Map entities = resource.getResources();
        if (entities == null || entities.isEmpty()) {
            return;
        }
        jgen.writeArrayFieldStart(ENTITIES);
        for (Map.Entry entry : entities.entrySet()) {
            for (Resource r : (List)entry.getValue()) {
                jgen.writeStartObject();
                jgen.writeArrayFieldStart("rel");
                jgen.writeString((String)entry.getKey());
                jgen.writeEndArray();
                this.renderJson((SirenResource)r, jgen);
                jgen.writeEndObject();
            }
        }
        jgen.writeEndArray();
    }

    private void writeProperties(Map<String, Object> properties, JsonGenerator jgen) throws JsonProcessingException, IOException {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        jgen.writeObjectFieldStart(PROPERTIES);
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            jgen.writeObjectField(entry.getKey(), entry.getValue());
        }
        jgen.writeEndObject();
    }

    private void writeActions(Collection<SirenAction> actions, JsonGenerator jgen) throws IOException {
        if (actions == null || actions.isEmpty()) {
            return;
        }
        jgen.writeArrayFieldStart(ACTIONS);
        for (SirenAction action : actions) {
            this.writeAction(action, jgen);
        }
        jgen.writeEndArray();
    }

    private void writeAction(SirenAction action, JsonGenerator jgen) throws IOException {
        if (action == null) {
            return;
        }
        jgen.writeStartObject();
        this.writeClass(action.getClasses(), jgen);
        jgen.writeStringField(NAME, action.getName());
        this.writeOptionalField(TITLE, action.getTitle(), jgen);
        this.writeOptionalField(METHOD, action.getMethod(), jgen);
        jgen.writeStringField(HREF, action.getHref());
        this.writeOptionalField(TYPE, action.getType(), jgen);
        this.writeFields(action.getFields(), jgen);
        jgen.writeEndObject();
    }

    private void writeFields(List<SirenField> fields, JsonGenerator jgen) throws IOException {
        if (fields == null) {
            return;
        }
        jgen.writeArrayFieldStart(FIELDS);
        for (SirenField field : fields) {
            jgen.writeObject((Object)field);
        }
        jgen.writeEndArray();
    }

    private void writeOptionalField(String name, String value, JsonGenerator jgen) throws IOException {
        if (value != null) {
            jgen.writeStringField(name, value);
        }
    }
}

