/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.contenttype;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MediaRange {
    private static final String MEDIA_TYPE_REGEX = "(\\S+?|\\*)/(\\S+?|\\*)";
    private static final Pattern MEDIA_TYPE_PATTERN = Pattern.compile("(\\S+?|\\*)/(\\S+?|\\*)");
    private static final String PARAMETER_REGEX = "(\\w+?)(?:\\s*?=\\s*?(\\S+?))";
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("(\\w+?)(?:\\s*?=\\s*?(\\S+?))");
    String name;
    String type;
    String subtype;
    float qvalue = 1.0f;
    Map<String, String> parameters = new HashMap<String, String>();

    public MediaRange(String value) {
        this.name = value;
    }

    public static MediaRange parse(String segment) {
        MediaRange r = new MediaRange(segment);
        String[] pieces = segment.split("\\s*;\\s*");
        Matcher x = MEDIA_TYPE_PATTERN.matcher(pieces[0]);
        if (x.matches()) {
            r.type = x.group(1);
            r.subtype = x.group(2);
        }
        for (int i = 1; i < pieces.length; ++i) {
            Matcher p = PARAMETER_PATTERN.matcher(pieces[i]);
            if (!p.matches()) continue;
            String token = p.group(1);
            String value = p.group(2);
            if ("q".equalsIgnoreCase(token)) {
                r.qvalue = Float.parseFloat(value);
                continue;
            }
            if (value != null) {
                r.parameters.put(token, value);
                continue;
            }
            r.parameters.put(token, null);
        }
        return r;
    }

    public String toString() {
        return this.name;
    }

    public String asMediaType() {
        StringBuilder b = new StringBuilder(this.type);
        b.append("/");
        b.append(this.subtype);
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            b.append("; ");
            b.append(entry.getKey());
            if (entry.getValue() == null) continue;
            b.append("=");
            b.append(entry.getValue());
        }
        return b.toString();
    }

    public int rankAgainst(MediaRange that) {
        int rank = -1;
        if ((this.type.equals(that.type) || "*".equals(this.type) || "*".equals(that.subtype)) && (this.subtype.equals(that.subtype) || "*".equals(that.subtype) || "*".equals(this.subtype))) {
            rank = 0;
            if (this.type.equals(that.type)) {
                rank += 100;
            }
            if (this.subtype.equals(that.subtype) && !"*".equals(this.subtype)) {
                rank += 50;
            }
            for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                String value = that.parameters.get(entry.getKey());
                if (value == null || !value.equals(entry.getValue())) continue;
                rank += 2;
            }
        }
        return rank;
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (this.getClass().isAssignableFrom(that.getClass())) {
            return this.equals((MediaRange)that);
        }
        return false;
    }

    public boolean equals(MediaRange that) {
        boolean result;
        if (that == null) {
            return false;
        }
        boolean bl = result = this.name.equals(that.name) && this.type.equals(that.type) && this.subtype.equals(that.subtype);
        if (!result) {
            return false;
        }
        if (this.qvalue != that.qvalue) {
            return false;
        }
        return this.parameters.equals(that.parameters);
    }

    public int hashCode() {
        return this.getClass().hashCode() + this.name.hashCode() + this.parameters.hashCode() + (int)((double)this.qvalue * 10.0);
    }
}

