/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.route;

import io.netty.handler.codec.http.HttpMethod;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.restexpress.Request;
import org.restexpress.Response;
import org.restexpress.exception.ServiceException;
import org.restexpress.url.UrlMatch;
import org.restexpress.url.UrlMatcher;

public abstract class Route {
    private UrlMatcher urlMatcher;
    private Object controller;
    private Method action;
    private HttpMethod method;
    private boolean shouldSerializeResponse = true;
    private String name;
    private String baseUrl;
    private List<String> supportedFormats = new ArrayList<String>();
    private String defaultFormat;
    private Set<String> flags = new HashSet<String>();
    private Map<String, Object> parameters = new HashMap<String, Object>();

    public Route(UrlMatcher urlMatcher, Object controller, Method action, HttpMethod method, boolean shouldSerializeResponse, String name, List<String> supportedFormats, String defaultFormat, Set<String> flags, Map<String, Object> parameters, String baseUrl) {
        this.urlMatcher = urlMatcher;
        this.controller = controller;
        this.action = action;
        this.action.setAccessible(true);
        this.method = method;
        this.shouldSerializeResponse = shouldSerializeResponse;
        this.name = name;
        this.supportedFormats.addAll(supportedFormats);
        this.defaultFormat = defaultFormat;
        this.flags.addAll(flags);
        this.parameters.putAll(parameters);
        this.baseUrl = baseUrl;
    }

    public boolean isFlagged(String flag) {
        if (flag == null) {
            return false;
        }
        return this.flags.contains(flag);
    }

    public boolean containsAllFlags(String[] flags) {
        if (flags == null) {
            return false;
        }
        return this.flags.containsAll(Arrays.asList(flags));
    }

    public boolean containsAnyFlags(String[] flags) {
        if (flags == null) {
            return false;
        }
        for (String flag : flags) {
            if (!this.isFlagged(flag)) continue;
            return true;
        }
        return false;
    }

    public boolean hasParameter(String name) {
        return this.getParameter(name) != null;
    }

    public Object getParameter(String name) {
        return this.parameters.get(name);
    }

    public Method getAction() {
        return this.action;
    }

    public Object getController() {
        return this.controller;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasName() {
        return this.getName() != null && !this.getName().trim().isEmpty();
    }

    public String getBaseUrl() {
        return this.baseUrl == null ? "" : this.baseUrl;
    }

    public String getFullPattern() {
        return this.getBaseUrl() + this.getPattern();
    }

    public String getPattern() {
        return this.urlMatcher.getPattern();
    }

    public boolean shouldSerializeResponse() {
        return this.shouldSerializeResponse;
    }

    public Collection<String> getSupportedFormats() {
        return Collections.unmodifiableList(this.supportedFormats);
    }

    public boolean hasSupportedFormats() {
        return !this.supportedFormats.isEmpty();
    }

    public void addAllSupportedFormats(List<String> formats) {
        this.supportedFormats.addAll(formats);
    }

    public void addSupportedFormat(String format) {
        if (!this.supportsFormat(format)) {
            this.supportedFormats.add(format);
        }
    }

    public boolean supportsFormat(String format) {
        return this.supportedFormats.contains(format);
    }

    public String getDefaultFormat() {
        return this.defaultFormat;
    }

    public boolean hasDefaultFormat() {
        return this.defaultFormat != null;
    }

    public UrlMatch match(String url) {
        return this.urlMatcher.match(url);
    }

    public List<String> getUrlParameters() {
        return this.urlMatcher.getParameterNames();
    }

    public Object invoke(Request request, Response response) {
        try {
            return this.action.invoke(this.controller, request, response);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (RuntimeException.class.isAssignableFrom(cause.getClass())) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(cause);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }
}

