/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.route;

import io.netty.handler.codec.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.restexpress.route.Action;
import org.restexpress.route.Route;
import org.restexpress.url.UrlMatch;

public class RouteMapping {
    private Map<HttpMethod, List<Route>> routes;
    private List<Route> deleteRoutes = new ArrayList<Route>();
    private List<Route> getRoutes = new ArrayList<Route>();
    private List<Route> postRoutes = new ArrayList<Route>();
    private List<Route> putRoutes = new ArrayList<Route>();
    private List<Route> optionRoutes = new ArrayList<Route>();
    private List<Route> headRoutes = new ArrayList<Route>();
    private Map<String, Map<HttpMethod, Route>> routesByName = new HashMap<String, Map<HttpMethod, Route>>();
    private Map<String, List<Route>> routesByPattern = new LinkedHashMap<String, List<Route>>();

    public RouteMapping() {
        this.routes = new HashMap<HttpMethod, List<Route>>();
        this.routes.put(HttpMethod.DELETE, this.deleteRoutes);
        this.routes.put(HttpMethod.GET, this.getRoutes);
        this.routes.put(HttpMethod.POST, this.postRoutes);
        this.routes.put(HttpMethod.PUT, this.putRoutes);
        this.routes.put(HttpMethod.HEAD, this.headRoutes);
        this.routes.put(HttpMethod.OPTIONS, this.optionRoutes);
    }

    public List<Route> getRoutesFor(HttpMethod method) {
        List<Route> routesFor = this.routes.get(method);
        if (routesFor == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(routesFor);
    }

    public Action getActionFor(HttpMethod method, String path) {
        for (Route route : this.routes.get(method)) {
            UrlMatch match = route.match(path);
            if (match == null) continue;
            return new Action(route, match);
        }
        return null;
    }

    public List<Route> getMatchingRoutes(String path) {
        for (List<Route> patternRoutes : this.routesByPattern.values()) {
            if (patternRoutes.get(0).match(path) == null) continue;
            return Collections.unmodifiableList(patternRoutes);
        }
        return Collections.emptyList();
    }

    public List<HttpMethod> getAllowedMethods(String path) {
        List<Route> matchingRoutes = this.getMatchingRoutes(path);
        if (matchingRoutes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HttpMethod> methods = new ArrayList<HttpMethod>();
        for (Route route : matchingRoutes) {
            methods.add(route.getMethod());
        }
        return methods;
    }

    public Route getNamedRoute(String name, HttpMethod method) {
        Map<HttpMethod, Route> routesByMethod = this.routesByName.get(name);
        if (routesByMethod == null) {
            return null;
        }
        return routesByMethod.get(method);
    }

    public void addRoute(Route route) {
        List<Route> list = this.routes.get(route.getMethod());
        if (list == null) {
            list = new ArrayList<Route>();
            this.routes.put(route.getMethod(), list);
        }
        list.add(route);
        this.addByPattern(route);
        if (route.hasName()) {
            this.addNamedRoute(route);
        }
    }

    private void addNamedRoute(Route route) {
        Map<HttpMethod, Route> routesByMethod = this.routesByName.get(route.getName());
        if (routesByMethod == null) {
            routesByMethod = new HashMap<HttpMethod, Route>();
            this.routesByName.put(route.getName(), routesByMethod);
        }
        routesByMethod.put(route.getMethod(), route);
    }

    private void addByPattern(Route route) {
        List<Route> urlRoutes = this.routesByPattern.get(route.getPattern());
        if (urlRoutes == null) {
            urlRoutes = new ArrayList<Route>();
            this.routesByPattern.put(route.getPattern(), urlRoutes);
        }
        urlRoutes.add(route);
    }
}

