/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.syntaxe;

import com.strategicgains.syntaxe.EncodingException;
import com.strategicgains.syntaxe.Validatable;
import com.strategicgains.syntaxe.ValidationException;
import com.strategicgains.syntaxe.annotation.FieldValidation;
import com.strategicgains.syntaxe.annotation.ObjectValidation;
import com.strategicgains.syntaxe.annotation.ValidationProvider;
import com.strategicgains.syntaxe.annotation.encoding.EncodingProvider;
import com.strategicgains.syntaxe.encoding.XssEncoder;
import com.strategicgains.syntaxe.util.ClassUtils;
import com.strategicgains.syntaxe.validator.AnnotatedFieldValidator;
import com.strategicgains.syntaxe.validator.Validator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ValidationEngine {
    private static final ConcurrentHashMap<Class<?>, List<Field>> cachedFieldsByClass = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Integer, List<Validator>> cachedValidatorsByHashcode = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class<?>, Validator> cachedObjectValidatorsByClass = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Integer, List<XssEncoder>> cachedEncodersByHashcode = new ConcurrentHashMap();
    private static final ThreadLocal<Set<Object>> visitedObjects = new ThreadLocal();

    private ValidationEngine() {
    }

    public static List<String> validate(Object object) {
        ArrayList<String> errors = new ArrayList<String>();
        if (ValidationEngine.visit(object)) {
            return errors;
        }
        ValidationEngine.encode(object);
        try {
            if (ValidationEngine.isValidatable(object)) {
                try {
                    ValidationEngine.callValidate((Validatable)object);
                }
                catch (ValidationException ve) {
                    errors.addAll(ve.getErrors());
                }
            }
            ValidationEngine.validateFields(object, errors);
            ValidationEngine.validateObject(object, errors);
        }
        catch (Exception e) {
            errors.add("Exception while validating: " + e.getMessage());
        }
        finally {
            if (ValidationEngine.isRootValidationObject(object)) {
                ValidationEngine.clearVisited();
            }
        }
        return errors;
    }

    public static void validateAndThrow(Object object) {
        List<String> errors = ValidationEngine.validate(object);
        if (!errors.isEmpty()) {
            throw new ValidationException(errors);
        }
    }

    public static void encode(Object object) {
        try {
            Collection<Field> fields = ValidationEngine.getAllDeclaredFields(object.getClass());
            for (Field field : fields) {
                List<XssEncoder> encoders = ValidationEngine.getEncoders(field, object);
                if (encoders.isEmpty()) continue;
                for (XssEncoder encoder : encoders) {
                    field.setAccessible(true);
                    String encoded = encoder.encode((String)field.get(object));
                    field.set(object, encoded);
                }
            }
        }
        catch (Exception e) {
            throw new EncodingException(e);
        }
    }

    private static void validateFields(Object object, List<String> errors) throws Exception {
        Collection<Field> fields = ValidationEngine.getAllDeclaredFields(object.getClass());
        for (Field field : fields) {
            List<Validator> validators = ValidationEngine.getValidators(field, object);
            if (validators.isEmpty()) continue;
            try {
                for (Validator validator : validators) {
                    validator.perform(object, errors);
                }
            }
            catch (ValidationException e) {
                e.printStackTrace();
            }
        }
    }

    private static List<Validator> getValidators(Field field, Object object) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        List<Validator> validators = cachedValidatorsByHashcode.get(field.hashCode());
        if (validators != null) {
            return validators;
        }
        validators = new ArrayList<Validator>();
        for (Annotation a : field.getAnnotations()) {
            Validator<Object> validator = null;
            Class<Validator<Object>> validatorClass = null;
            if (a.annotationType().isAnnotationPresent(ValidationProvider.class)) {
                ValidationProvider providerAnnotation = a.annotationType().getAnnotation(ValidationProvider.class);
                validatorClass = providerAnnotation.value();
            } else if (a.annotationType().isAssignableFrom(FieldValidation.class)) {
                validatorClass = ((FieldValidation)a).value();
            }
            if (validatorClass == null) continue;
            if (AnnotatedFieldValidator.class.isAssignableFrom(validatorClass)) {
                Constructor<Validator<Object>> constructor = validatorClass.getConstructor(Field.class, a.annotationType());
                if (constructor != null) {
                    validator = constructor.newInstance(field, a);
                }
            } else {
                validator = validatorClass.newInstance();
            }
            if (validator == null) continue;
            validators.add(validator);
        }
        cachedValidatorsByHashcode.put(field.hashCode(), validators);
        return validators;
    }

    private static List<XssEncoder> getEncoders(Field field, Object object) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        List<XssEncoder> encoders = cachedEncodersByHashcode.get(field.hashCode());
        if (encoders != null) {
            return encoders;
        }
        encoders = new ArrayList<XssEncoder>();
        for (Annotation a : field.getAnnotations()) {
            if (a.annotationType().isAnnotationPresent(EncodingProvider.class)) {
                EncodingProvider providerAnnotation = a.annotationType().getAnnotation(EncodingProvider.class);
                Constructor<? extends XssEncoder> constructor = providerAnnotation.value().getConstructor(new Class[0]);
                XssEncoder provider = constructor.newInstance(new Object[0]);
                encoders.add(provider);
                continue;
            }
            if (!a.annotationType().isAssignableFrom(EncodingProvider.class)) continue;
            Class<? extends XssEncoder> vc = ((EncodingProvider)a).value();
            encoders.add(vc.newInstance());
        }
        cachedEncodersByHashcode.put(field.hashCode(), encoders);
        return encoders;
    }

    private static Collection<Field> getAllDeclaredFields(Class<?> aClass) {
        List<Field> fields = cachedFieldsByClass.get(aClass);
        if (fields == null) {
            fields = ClassUtils.getAllDeclaredFields(aClass);
            cachedFieldsByClass.put(aClass, fields);
        }
        return fields;
    }

    private static void validateObject(Object object, List<String> errors) throws InstantiationException, IllegalAccessException {
        ObjectValidation annotation = object.getClass().getAnnotation(ObjectValidation.class);
        if (annotation == null) {
            return;
        }
        Validator validator = cachedObjectValidatorsByClass.get(object.getClass());
        if (validator == null) {
            validator = annotation.value().newInstance();
            cachedObjectValidatorsByClass.put(object.getClass(), validator);
        }
        validator.perform(object, errors);
    }

    private static boolean isValidatable(Object object) {
        return Validatable.class.isAssignableFrom(object.getClass());
    }

    private static void callValidate(Validatable object) {
        object.validate();
    }

    private static boolean visit(Object object) {
        Set<Object> s = visitedObjects.get();
        if (s != null && s.contains(object)) {
            return true;
        }
        ValidationEngine.markVisited(object);
        return false;
    }

    private static void markVisited(Object object) {
        Set<Object> s = visitedObjects.get();
        if (s == null) {
            s = new LinkedHashSet<Object>();
            visitedObjects.set(s);
        }
        s.add(object);
    }

    private static void clearVisited() {
        Set<Object> s = visitedObjects.get();
        if (s != null) {
            s.clear();
            visitedObjects.remove();
        }
    }

    private static boolean isRootValidationObject(Object object) {
        Set<Object> s = visitedObjects.get();
        if (s != null && s.iterator().hasNext()) {
            return s.iterator().next() == object;
        }
        return false;
    }
}

