/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.syntaxe.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClassUtils {
    public static final int IGNORED_FIELD_MODIFIERS = 152;

    private ClassUtils() {
    }

    public static List<Field> getAllDeclaredFields(Class<?> aClass) {
        return ClassUtils.getAllDeclaredFields(aClass, 152);
    }

    public static List<Field> getAllDeclaredFields(Class<?> aClass, int modifiers) {
        FieldListClosure closure = new FieldListClosure(new ArrayList<Field>(), modifiers);
        ClassUtils.computeDeclaredFields(aClass, closure);
        return closure.getValues();
    }

    public static HashMap<String, Field> getAllDeclaredFieldsByName(Class<?> aClass) {
        return ClassUtils.getAllDeclaredFieldsByName(aClass, 152);
    }

    public static HashMap<String, Field> getAllDeclaredFieldsByName(Class<?> aClass, int modifiers) {
        FieldMapClosure closure = new FieldMapClosure(new HashMap<String, Field>(), modifiers);
        ClassUtils.computeDeclaredFields(aClass, closure);
        return closure.getValues();
    }

    public static <T> T computeDeclaredFields(Class<?> aClass, FieldClosure<T> function) {
        for (Field field : aClass.getDeclaredFields()) {
            function.perform(field);
        }
        if (aClass.getSuperclass() != null) {
            ClassUtils.computeDeclaredFields(aClass.getSuperclass(), function);
        }
        return function.getValues();
    }

    private static class FieldMapClosure
    implements FieldClosure<Map<String, Field>> {
        private HashMap<String, Field> values;
        private int ignoredModifiers;

        public FieldMapClosure(HashMap<String, Field> values, int modifiers) {
            this.values = values;
            this.ignoredModifiers = modifiers;
        }

        @Override
        public void perform(Field field) {
            if ((field.getModifiers() & this.ignoredModifiers) == 0) {
                this.values.put(field.getName(), field);
            }
        }

        @Override
        public HashMap<String, Field> getValues() {
            return this.values;
        }
    }

    private static class FieldListClosure
    implements FieldClosure<List<Field>> {
        private List<Field> values;
        private int ignoredModifiers;

        public FieldListClosure(List<Field> values, int modifiers) {
            this.values = values;
            this.ignoredModifiers = modifiers;
        }

        @Override
        public void perform(Field field) {
            if ((field.getModifiers() & this.ignoredModifiers) == 0) {
                this.values.add(field);
            }
        }

        @Override
        public List<Field> getValues() {
            return this.values;
        }
    }

    public static interface FieldClosure<T> {
        public void perform(Field var1);

        public T getValues();
    }
}

