/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.syntaxe.util;

import java.util.List;

public class Validations {
    private static final String MAX_LENGTH_ERROR = "%s is limited to %d characters";
    private static final String MIN_LENGTH_ERROR = "%s must contain at least %d characters";
    private static final String LESS_THAN_OR_EQUAL_ERROR = "%s must be less-than or equal-to %d";
    private static final String GREATER_THAN_OR_EQUAL_ERROR = "%s must be greater-than or equal-to %d";
    private static final String LESS_THAN_OR_EQUAL_FLOAT_ERROR = "%s must be less-than or equal-to %f";
    private static final String GREATER_THAN_OR_EQUAL_FLOAT_ERROR = "%s must be greater-than or equal-to %f";
    private static final String LESS_THAN_OR_EQUAL_DOUBLE_ERROR = "%s must be less-than or equal-to %f";
    private static final String GREATER_THAN_OR_EQUAL_DOUBLE_ERROR = "%s must be greater-than or equal-to %f";

    private Validations() {
    }

    public static void require(String name, String value, List<String> errors) {
        if (value == null || value.trim().isEmpty()) {
            errors.add(name + " is required");
        }
    }

    public static void maxLength(String name, String value, int max, List<String> errors) {
        if (value == null) {
            return;
        }
        if (value.length() > max) {
            errors.add(String.format(MAX_LENGTH_ERROR, name, max));
        }
    }

    public static void minLength(String name, String value, int min, List<String> errors) {
        if (value == null) {
            return;
        }
        if (value.length() < min) {
            errors.add(String.format(MIN_LENGTH_ERROR, name, min));
        }
    }

    public static void lessThanOrEqual(String name, int actual, int max, List<String> errors) {
        if (actual > max) {
            errors.add(String.format(LESS_THAN_OR_EQUAL_ERROR, name, max));
        }
    }

    public static void greaterThanOrEqual(String name, int actual, int min, List<String> errors) {
        if (actual < min) {
            errors.add(String.format(GREATER_THAN_OR_EQUAL_ERROR, name, min));
        }
    }

    public static void lessThanOrEqual(String name, long actual, long max, List<String> errors) {
        if (actual > max) {
            errors.add(String.format(LESS_THAN_OR_EQUAL_ERROR, name, max));
        }
    }

    public static void greaterThanOrEqual(String name, long actual, long min, List<String> errors) {
        if (actual < min) {
            errors.add(String.format(GREATER_THAN_OR_EQUAL_ERROR, name, min));
        }
    }

    public static void lessThanOrEqual(String name, float actual, float max, List<String> errors) {
        if (actual > max) {
            errors.add(String.format("%s must be less-than or equal-to %f", name, Float.valueOf(max)));
        }
    }

    public static void greaterThanOrEqual(String name, float actual, float min, List<String> errors) {
        if (actual < min) {
            errors.add(String.format("%s must be greater-than or equal-to %f", name, Float.valueOf(min)));
        }
    }

    public static void lessThanOrEqual(String name, double actual, double max, List<String> errors) {
        if (actual > max) {
            errors.add(String.format("%s must be less-than or equal-to %f", name, max));
        }
    }

    public static void greaterThanOrEqual(String name, double actual, double min, List<String> errors) {
        if (actual < min) {
            errors.add(String.format("%s must be greater-than or equal-to %f", name, min));
        }
    }
}

