/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.syntaxe.validator.impl;

import com.strategicgains.syntaxe.annotation.DoubleValidation;
import com.strategicgains.syntaxe.util.Validations;
import com.strategicgains.syntaxe.validator.AnnotatedFieldValidator;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;

public class DoubleValidator
extends AnnotatedFieldValidator<DoubleValidation> {
    public DoubleValidator(Field field, DoubleValidation annotation) {
        super(field, annotation);
    }

    @Override
    public void perform(Object instance, List<String> errors) {
        String name = this.determineName();
        Object value = this.getValue(instance);
        if (value == null) {
            if (!((DoubleValidation)this.getAnnotation()).isNullable()) {
                Validations.require(name, null, errors);
            }
            return;
        }
        if (this.isArray()) {
            this.validateArray(name, !((DoubleValidation)this.getAnnotation()).isNullable(), (Object[])value, errors);
        } else if (this.isCollection()) {
            this.validateCollection(name, !((DoubleValidation)this.getAnnotation()).isNullable(), (Collection)value, errors);
        } else {
            this.validate(name, value, errors);
        }
    }

    @Override
    protected void validate(String name, Object value, List<String> errors) {
        double doubleValue;
        if (((DoubleValidation)this.getAnnotation()).min() != Double.MIN_VALUE) {
            doubleValue = (Double)value;
            Validations.greaterThanOrEqual(name, doubleValue, ((DoubleValidation)this.getAnnotation()).min(), errors);
        }
        if (((DoubleValidation)this.getAnnotation()).max() != Double.MAX_VALUE) {
            doubleValue = (Double)value;
            Validations.lessThanOrEqual(name, doubleValue, ((DoubleValidation)this.getAnnotation()).max(), errors);
        }
    }

    private String determineName() {
        return ((DoubleValidation)this.getAnnotation()).name().isEmpty() ? this.getFieldName() : ((DoubleValidation)this.getAnnotation()).name();
    }
}

