/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.syntaxe.validator.impl;

import com.strategicgains.syntaxe.annotation.Required;
import com.strategicgains.syntaxe.util.Validations;
import com.strategicgains.syntaxe.validator.AnnotatedFieldValidator;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;

public class RequiredValidator
extends AnnotatedFieldValidator<Required> {
    public RequiredValidator(Field field, Required annotation) {
        super(field, annotation);
    }

    @Override
    public void perform(Object instance, List<String> errors) {
        String name = this.determineName();
        Object value = this.getValue(instance);
        if (value == null) {
            errors.add(name + " is required");
            return;
        }
        if (this.isCollection()) {
            this.validateCollection(name, true, value == null ? null : (Collection)value, errors);
        }
        if (this.isArray()) {
            this.validateArray(name, true, value == null ? null : (Object[])value, errors);
        } else {
            Validations.require(name, value == null ? null : String.valueOf(value), errors);
        }
    }

    @Override
    protected void validate(String name, Object value, List<String> errors) {
        Validations.require(name, value == null ? null : String.valueOf(value), errors);
    }

    protected String determineName() {
        return ((Required)this.getAnnotation()).value().isEmpty() ? this.getFieldName() : ((Required)this.getAnnotation()).value();
    }
}

