/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.syntaxe.validator.impl;

import com.strategicgains.syntaxe.annotation.StringValidation;
import com.strategicgains.syntaxe.util.Validations;
import com.strategicgains.syntaxe.validator.AnnotatedFieldValidator;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;

public class StringValidator
extends AnnotatedFieldValidator<StringValidation> {
    public StringValidator(Field field, StringValidation annotation) {
        super(field, annotation);
    }

    @Override
    public void perform(Object instance, List<String> errors) {
        String name = this.determineName();
        Object value = this.getValue(instance);
        if (((StringValidation)this.getAnnotation()).required() && value == null) {
            errors.add(name + " is required");
            return;
        }
        if (this.isCollection()) {
            this.validateCollection(name, ((StringValidation)this.getAnnotation()).required(), value == null ? null : (Collection)value, errors);
        } else if (this.isArray()) {
            this.validateArray(name, ((StringValidation)this.getAnnotation()).required(), value == null ? null : (Object[])value, errors);
        } else {
            this.validateString(name, value == null ? null : String.valueOf(value), errors);
        }
    }

    @Override
    protected void validate(String name, Object value, List<String> errors) {
        this.validateString(name, value == null ? null : String.valueOf(value), errors);
    }

    private void validateString(String name, String stringValue, List<String> errors) {
        if (((StringValidation)this.getAnnotation()).required()) {
            Validations.require(name, stringValue, errors);
        }
        if (((StringValidation)this.getAnnotation()).minLength() > 0) {
            Validations.minLength(name, stringValue, ((StringValidation)this.getAnnotation()).minLength(), errors);
        }
        if (((StringValidation)this.getAnnotation()).maxLength() > 0) {
            Validations.maxLength(name, stringValue, ((StringValidation)this.getAnnotation()).maxLength(), errors);
        }
    }

    protected String determineName() {
        return ((StringValidation)this.getAnnotation()).name().isEmpty() ? this.getFieldName() : ((StringValidation)this.getAnnotation()).name();
    }
}

