/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.restexpress.plugin.cors;

import java.util.Properties;
import org.restexpress.common.exception.ConfigurationException;

public class CorsConfig {
    private static final String DOMAINS_PROPERTY = "cors.origins";
    private static final String EXPOSED_HEADERS_PROPERTY = "cors.exposedHeaders";
    private static final String ALLOWED_HEADERS_PROPERTY = "cors.allowedHeaders";
    private static final String MAX_AGE_PROPERTY = "cors.maxAge";
    private String origins;
    private String exposedHeaders;
    private String allowedHeaders;
    private long maxAge;

    public CorsConfig(Properties p) {
        this.origins = p.getProperty(DOMAINS_PROPERTY);
        if (this.origins == null) {
            throw new ConfigurationException("Please define CORS origins for property: cors.origins");
        }
        this.exposedHeaders = p.getProperty(EXPOSED_HEADERS_PROPERTY);
        if (this.exposedHeaders == null) {
            throw new ConfigurationException("Please define CORS exposed headers for property: cors.exposedHeaders");
        }
        this.allowedHeaders = p.getProperty(ALLOWED_HEADERS_PROPERTY);
        if (this.allowedHeaders == null) {
            throw new ConfigurationException("Please define CORS allowed headers for property: cors.allowedHeaders");
        }
        try {
            this.maxAge = Long.parseLong(p.getProperty(MAX_AGE_PROPERTY));
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Please define CORS max age in seconds for property: cors.maxAge");
        }
    }

    public String getOrigins() {
        return this.origins;
    }

    public String getExposedHeaders() {
        return this.exposedHeaders;
    }

    public String getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public long getMaxAge() {
        return this.maxAge;
    }
}

