/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.restexpress.plugin.cors;

import io.netty.handler.codec.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.restexpress.Request;
import org.restexpress.Response;
import org.restexpress.RestExpress;
import org.restexpress.common.util.StringUtils;
import org.restexpress.domain.metadata.RouteMetadata;
import org.restexpress.pipeline.Postprocessor;
import org.restexpress.plugin.AbstractPlugin;
import org.restexpress.route.RouteBuilder;
import org.restexpress.util.Callback;

public class CorsHeaderPlugin
extends AbstractPlugin {
    private static final String CORS_ALLOW_ORIGIN_HEADER = "Access-Control-Allow-Origin";
    private String allowOriginHeader;
    private String exposeHeadersHeader;
    private String allowHeadersHeader;
    private Long maxAge;
    private Map<String, Set<HttpMethod>> methodsByPattern = new LinkedHashMap<String, Set<HttpMethod>>();
    private List<RouteBuilder> routeBuilders = new ArrayList<RouteBuilder>();
    private boolean isPreflightSupported = true;
    private List<String> flags = new ArrayList<String>();
    private Map<String, Object> parameters = new HashMap<String, Object>();

    public CorsHeaderPlugin(String ... origins) {
        this.allowOriginHeader = StringUtils.join((String)" ", (Object[])origins);
    }

    public CorsHeaderPlugin maxAge(long seconds) {
        if (this.isRegistered()) {
            throw new UnsupportedOperationException("CorsHeaderPlugin.maxAge(long) must be called before register()");
        }
        this.maxAge = seconds;
        return this;
    }

    public CorsHeaderPlugin exposeHeaders(String ... exposeHeaders) {
        this.exposeHeadersHeader = StringUtils.join((String)",", (Object[])exposeHeaders);
        return this;
    }

    public CorsHeaderPlugin allowHeaders(String ... allowHeaders) {
        this.allowHeadersHeader = StringUtils.join((String)",", (Object[])allowHeaders);
        return this;
    }

    public CorsHeaderPlugin noPreflightSupport() {
        if (this.isRegistered()) {
            throw new UnsupportedOperationException("CorsHeaderPlugin.noPreflightSupport() must be called before register()");
        }
        this.isPreflightSupported = false;
        return this;
    }

    public CorsHeaderPlugin flag(String flagValue) {
        if (this.isRegistered()) {
            throw new UnsupportedOperationException("CorsHeaderPlugin.flag(String) must be called before register()");
        }
        if (!this.flags.contains(flagValue)) {
            this.flags.add(flagValue);
        }
        return this;
    }

    public CorsHeaderPlugin parameter(String name, Object value) {
        if (this.isRegistered()) {
            throw new UnsupportedOperationException("CorsHeaderPlugin.parameter(String, Object) must be called before register()");
        }
        this.parameters.put(name, value);
        return this;
    }

    public CorsHeaderPlugin register(RestExpress server) {
        if (this.isRegistered()) {
            return this;
        }
        super.register(server);
        CorsHeaderPostprocessor proc = new CorsHeaderPostprocessor(this.allowOriginHeader, this.exposeHeadersHeader);
        server.addFinallyProcessor((Postprocessor)proc);
        server.iterateRouteBuilders((Callback)new Callback<RouteBuilder>(){

            public void process(RouteBuilder builder) {
                RouteMetadata rmd = builder.asMetadata();
                HashSet<HttpMethod> methods = new HashSet<HttpMethod>();
                for (String methodString : rmd.getMethods()) {
                    methods.add(HttpMethod.valueOf((String)methodString));
                }
                if (CorsHeaderPlugin.this.isPreflightSupported && !methods.contains(HttpMethod.OPTIONS)) {
                    methods.add(HttpMethod.OPTIONS);
                }
                String pathPattern = rmd.getUri().getPattern();
                this.updateAcceptedMethods(methods, pathPattern);
                for (String alias : rmd.getAliases()) {
                    this.updateAcceptedMethods(methods, alias);
                }
            }

            private void updateAcceptedMethods(Set<HttpMethod> methods, String pathPattern) {
                Set<HttpMethod> existingMethods = (Set<HttpMethod>)CorsHeaderPlugin.this.methodsByPattern.get(pathPattern);
                if (existingMethods != null) {
                    existingMethods.addAll(methods);
                } else {
                    existingMethods = methods;
                }
                CorsHeaderPlugin.this.methodsByPattern.put(pathPattern, existingMethods);
            }
        });
        if (this.isPreflightSupported) {
            this.addPreflightOptionsRequestSupport(server);
        }
        return this;
    }

    public void bind(RestExpress server) {
    }

    private void addPreflightOptionsRequestSupport(RestExpress server) {
        CorsOptionsController corsOptionsController = new CorsOptionsController(this.allowOriginHeader, this.maxAge, this.methodsByPattern, this.allowHeadersHeader);
        for (String pattern : this.methodsByPattern.keySet()) {
            RouteBuilder rb = server.uri(pattern, (Object)corsOptionsController).action("options", HttpMethod.OPTIONS).noSerialization().flag("not.secured").flag("no.authorization");
            for (String string : this.flags) {
                rb.flag(string);
            }
            for (Map.Entry entry : this.parameters.entrySet()) {
                rb.parameter((String)entry.getKey(), entry.getValue());
            }
            this.routeBuilders.add(rb);
        }
    }

    private class CorsOptionsController {
        private static final String CORS_MAX_AGE_HEADER = "Access-Control-Max-Age";
        private static final String CORS_ALLOW_METHODS_HEADER = "Access-Control-Allow-Methods";
        private static final String CORS_ALLOW_HEADERS_HEADER = "Access-Control-Allow-Headers";
        private String allowOriginsHeader;
        private Map<String, String> allowedMethodsByPattern = new HashMap<String, String>();
        private Long maxAge;
        private String allowHeadersHeader;

        public CorsOptionsController(String allowOriginsHeader, Long maxAge, Map<String, Set<HttpMethod>> methodsByPattern, String allowHeadersHeader) {
            this.allowOriginsHeader = allowOriginsHeader;
            this.maxAge = maxAge == null ? null : Long.valueOf(maxAge);
            this.allowHeadersHeader = allowHeadersHeader;
            for (Map.Entry<String, Set<HttpMethod>> entry : methodsByPattern.entrySet()) {
                String pathPattern = entry.getKey().replaceFirst("\\.\\{format\\}", "");
                this.allowedMethodsByPattern.put(pathPattern, StringUtils.join((String)",", (Collection)entry.getValue()));
            }
        }

        public void options(Request request, Response response) {
            response.addHeader(CorsHeaderPlugin.CORS_ALLOW_ORIGIN_HEADER, this.allowOriginsHeader);
            response.addHeader(CORS_ALLOW_METHODS_HEADER, this.allowedMethodsByPattern.get(request.getResolvedRoute().getPattern()));
            response.addHeader("Content-Length", "0");
            response.setContentType("text/plain; charset=UTF-8");
            if (this.maxAge != null && !response.hasHeader(CORS_MAX_AGE_HEADER)) {
                response.addHeader(CORS_MAX_AGE_HEADER, String.valueOf(this.maxAge));
            }
            if (this.allowHeadersHeader != null) {
                response.addHeader(CORS_ALLOW_HEADERS_HEADER, this.allowHeadersHeader);
            }
        }
    }

    private class CorsHeaderPostprocessor
    implements Postprocessor {
        private static final String CORS_EXPOSE_HEADERS_HEADER = "Access-Control-Expose-Headers";
        private String allowOriginHeader = null;
        private String exposeHeadersHeader = null;

        public CorsHeaderPostprocessor(String allowOriginHeader, String exposeHeadersHeader) {
            this.allowOriginHeader = allowOriginHeader;
            this.exposeHeadersHeader = exposeHeadersHeader;
        }

        public void process(Request request, Response response) {
            if (!response.hasHeader(CorsHeaderPlugin.CORS_ALLOW_ORIGIN_HEADER) && this.allowOriginHeader != null) {
                response.addHeader(CorsHeaderPlugin.CORS_ALLOW_ORIGIN_HEADER, this.allowOriginHeader);
            }
            if (!response.hasHeader(CORS_EXPOSE_HEADERS_HEADER) && this.exposeHeadersHeader != null) {
                response.addHeader(CORS_EXPOSE_HEADERS_HEADER, this.exposeHeadersHeader);
            }
        }
    }
}

