/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.restexpress.plugin.metrics;

import java.util.Properties;
import org.restexpress.common.exception.ConfigurationException;

public class MetricsConfig {
    private static final String METRICS_IS_ENABLED_PROPERTY = "metrics.isEnabled";
    private static final String METRICS_PREFIX_PROPERTY = "metrics.prefix";
    private static final String GRAPHITE_IS_ENABLED_PROPERTY = "metrics.graphite.isEnabled";
    private static final String GRAPHITE_HOST_PROPERTY = "metrics.graphite.host";
    private static final String GRAPHITE_PORT_PROPERTY = "metrics.graphite.port";
    private static final String GRAPHITE_PUBLISHING_SECONDS_PROPERTY = "metrics.graphite.publishSeconds";
    private boolean isEnabled;
    private boolean isGraphiteEnabled;
    private String graphiteHost;
    private Integer graphitePort;
    private Integer publishSeconds;
    private String prefix;

    public MetricsConfig(Properties p) {
        this.isEnabled = Boolean.parseBoolean(p.getProperty(METRICS_IS_ENABLED_PROPERTY, "true"));
        if (!this.isEnabled) {
            return;
        }
        this.isGraphiteEnabled = Boolean.parseBoolean(p.getProperty(GRAPHITE_IS_ENABLED_PROPERTY, "true"));
        if (!this.isGraphiteEnabled) {
            return;
        }
        this.prefix = p.getProperty(METRICS_PREFIX_PROPERTY);
        if (this.prefix == null) {
            throw new ConfigurationException("Please define a metrics prefix for property: metrics.prefix");
        }
        this.graphiteHost = p.getProperty(GRAPHITE_HOST_PROPERTY);
        if (this.graphiteHost == null) {
            throw new ConfigurationException("Please define a graphite host for property: metrics.graphite.host");
        }
        try {
            this.graphitePort = Integer.parseInt(p.getProperty(GRAPHITE_PORT_PROPERTY));
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Please define a graphite port for property: metrics.graphite.port", (Throwable)e);
        }
        try {
            this.publishSeconds = Integer.parseInt(p.getProperty(GRAPHITE_PUBLISHING_SECONDS_PROPERTY));
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Please define how frequently (in seconds) to publish to graphite in property: metrics.graphite.publishSeconds", (Throwable)e);
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isGraphiteEnabled() {
        return this.isGraphiteEnabled;
    }

    public String getGraphiteHost() {
        return this.graphiteHost;
    }

    public Integer getGraphitePort() {
        return this.graphitePort;
    }

    public Integer getPublishSeconds() {
        return this.publishSeconds;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

