/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.restexpress.plugin.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.restexpress.Request;
import org.restexpress.Response;
import org.restexpress.RestExpress;
import org.restexpress.pipeline.MessageObserver;
import org.restexpress.pipeline.Postprocessor;
import org.restexpress.pipeline.Preprocessor;
import org.restexpress.plugin.Plugin;

public class MetricsPlugin
extends MessageObserver
implements Plugin,
Preprocessor,
Postprocessor {
    private static final ConcurrentHashMap<String, Timer> ROUTE_TIMERS = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Long> START_TIMES_BY_CORRELATION_ID = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Counter> EXCEPTION_COUNTERS_BY_ROUTE = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Integer, Counter> COUNTERS_BY_RESPONSE = new ConcurrentHashMap();
    private MetricRegistry metrics;
    private Counter activeRequestsCounter;
    private Counter allExceptionsCounter;
    private Timer allTimesTimer;
    private boolean isRegistered = false;

    public MetricsPlugin(MetricRegistry registry) {
        this.metrics = registry;
    }

    public MetricsPlugin register(RestExpress server) {
        if (this.isRegistered) {
            return this;
        }
        server.registerPlugin((Plugin)this);
        this.isRegistered = true;
        server.addMessageObserver((MessageObserver)this).addPreprocessor((Preprocessor)this).addFinallyProcessor((Postprocessor)this);
        return this;
    }

    public void bind(RestExpress server) {
        this.activeRequestsCounter = this.metrics.counter("active-requests");
        this.allExceptionsCounter = this.metrics.counter("all-exceptions");
        this.allTimesTimer = this.metrics.timer("all-times");
    }

    public void shutdown(RestExpress server) {
    }

    protected void onReceived(Request request, Response response) {
        this.activeRequestsCounter.inc();
        START_TIMES_BY_CORRELATION_ID.put(request.getCorrelationId(), System.nanoTime());
    }

    protected void onException(Throwable exception, Request request, Response response) {
        this.allExceptionsCounter.inc();
        String name = this.getRouteName(request);
        if (name == null || name.isEmpty()) {
            return;
        }
        Counter exceptionCounter = EXCEPTION_COUNTERS_BY_ROUTE.get(name);
        if (exceptionCounter == null) {
            return;
        }
        exceptionCounter.inc();
    }

    protected void onComplete(Request request, Response response) {
        Counter responseCounter;
        this.activeRequestsCounter.dec();
        Long duration = this.computeDurationMillis(START_TIMES_BY_CORRELATION_ID.remove(request.getCorrelationId()));
        if (duration != null && duration > 0L) {
            this.allTimesTimer.update(duration.longValue(), TimeUnit.MILLISECONDS);
            String name = this.getRouteName(request);
            if (name == null || name.isEmpty()) {
                return;
            }
            Timer timer = ROUTE_TIMERS.get(name);
            if (timer != null) {
                timer.update(duration.longValue(), TimeUnit.MILLISECONDS);
            }
        }
        if ((responseCounter = COUNTERS_BY_RESPONSE.get(response.getResponseStatus().code())) == null) {
            responseCounter = this.metrics.counter(this.getResponseCounterName(response.getResponseStatus()));
            COUNTERS_BY_RESPONSE.putIfAbsent(response.getResponseStatus().code(), responseCounter);
        }
        responseCounter.inc();
        this.publish(request, response, duration);
    }

    protected void publish(Request request, Response response, Long duration) {
    }

    public void process(Request request) {
        String name = this.getRouteName(request);
        if (name == null || name.isEmpty()) {
            return;
        }
        if (!ROUTE_TIMERS.containsKey(name)) {
            ROUTE_TIMERS.putIfAbsent(name, this.metrics.timer(this.getTimerName(name)));
        }
        if (!EXCEPTION_COUNTERS_BY_ROUTE.containsKey(name)) {
            EXCEPTION_COUNTERS_BY_ROUTE.putIfAbsent(name, this.metrics.counter(this.getExceptionCounterName(name)));
        }
    }

    public void process(Request request, Response response) {
        Long duration = this.computeDurationMillis(START_TIMES_BY_CORRELATION_ID.get(request.getCorrelationId()));
        if (duration != null && duration > 0L) {
            response.addHeader("X-Response-Time", String.valueOf(duration));
        }
    }

    private Long computeDurationMillis(Long started) {
        Long duration = 0L;
        if (started != null && started > 0L) {
            duration = Math.max(0L, (System.nanoTime() - started) / 1000000L);
        }
        return duration;
    }

    private String getRouteName(Request request) {
        if (request.getResolvedRoute() == null) {
            return "";
        }
        String name = request.getResolvedRoute().getName();
        if (name == null || name.trim().isEmpty()) {
            name = request.getResolvedRoute().getPattern();
        }
        return name;
    }

    private String getTimerName(String routeName) {
        return routeName + "-times";
    }

    private String getExceptionCounterName(String routeName) {
        return routeName + "-exceptions";
    }

    private String getResponseCounterName(HttpResponseStatus responseStatus) {
        return responseStatus.code() + "-" + responseStatus.reasonPhrase() + "-count";
    }
}

